/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class ListeningDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-ListeningDICookie";
    private ListeningConnector listeningConnector;
    private Map<String, ? extends Connector.Argument> args;
    private boolean isListening = false;

    private ListeningDICookie(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> args) {
        this.listeningConnector = listeningConnector;
        this.args = args;
    }

    public static ListeningDICookie create(ListeningConnector listeningConnector, Map<String, ? extends Connector.Argument> args) {
        return new ListeningDICookie(listeningConnector, args);
    }

    public static ListeningDICookie create(int portNumber) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), portNumber));
    }

    public static ListeningDICookie create(String name) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), name));
    }

    private static ListeningConnector findListeningConnector(String s) {
        for (ListeningConnector ac : Bootstrap.virtualMachineManager().listeningConnectors()) {
            if (ac.transport() == null || ac.transport().name().toLowerCase().indexOf(s) <= -1) continue;
            return ac;
        }
        return null;
    }

    private static Map<String, ? extends Connector.Argument> getArgs(ListeningConnector listeningConnector, int portNumber) {
        Map<String, Connector.Argument> args = listeningConnector.defaultArguments();
        args.get("port").setValue("" + portNumber);
        return args;
    }

    private static Map<String, ? extends Connector.Argument> getArgs(ListeningConnector listeningConnector, String name) {
        Map<String, Connector.Argument> args = listeningConnector.defaultArguments();
        args.get("name").setValue(name);
        return args;
    }

    public ListeningConnector getListeningConnector() {
        return this.listeningConnector;
    }

    public Map<String, ? extends Connector.Argument> getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument a = this.args.get("port");
        if (a == null) {
            return -1;
        }
        String pn = a.value();
        if (pn == null || pn.length() == 0) {
            try {
                String address = this.listeningConnector.startListening(this.args);
                this.isListening = true;
                int splitIndex = address.indexOf(58);
                String localaddr = null;
                if (splitIndex >= 0) {
                    localaddr = address.substring(0, splitIndex);
                    address = address.substring(splitIndex + 1);
                }
                a.setValue(address);
                pn = address;
            }
            catch (IOException ex) {
            }
            catch (IllegalConnectorArgumentsException ex) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(pn);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getSharedMemoryName() {
        Connector.Argument a = this.args.get("name");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        try {
            if (!this.isListening) {
                try {
                    this.listeningConnector.startListening(this.args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            VirtualMachine virtualMachine = this.listeningConnector.accept(this.args);
            return virtualMachine;
        }
        finally {
            try {
                this.listeningConnector.stopListening(this.args);
            }
            catch (Exception exception) {}
        }
    }
}

