/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers.scripted;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.AbstractIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.ProfilerScriptModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptModificationException;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.attach.spi.RunException;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.openide.util.RequestProcessor;

public abstract class AbstractScriptIntegrationProvider
extends AbstractIntegrationProvider {
    private String installationPath = "";

    public AbstractScriptIntegrationProvider() {
        this.attachedWizard = new NullWizardStep();
    }

    public void setInstallationPath(String path) {
        this.installationPath = path;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    @Override
    public void categorize(IntegrationCategorizer categorizer) {
        categorizer.addAppserver(this, this.getAttachWizardPriority());
    }

    @Override
    public void modify(AttachSettings attachSettings) throws ModificationException {
        try {
            this.modifyScriptForAttach(attachSettings);
        }
        catch (ScriptModificationException e) {
            throw new ModificationException(e);
        }
    }

    @Override
    public void run(AttachSettings attachSettings) throws RunException {
        if (attachSettings.isRemote()) {
            return;
        }
        boolean isDirectAttach = attachSettings.isDirect();
        String targetOS = attachSettings.getHostOS();
        Collection commandsArray = this.prepareCommands(targetOS);
        final String[] commands = commandsArray.toArray(new String[0]);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader input = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(commands).getInputStream()));
                    while (input.readLine() != null) {
                    }
                    input.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public abstract ValidationResult validateInstallation(String var1, String var2);

    protected abstract boolean isBackupRequired();

    protected abstract ScriptHeaderModifier getHeaderModifier(String var1);

    protected abstract String getModifiedScriptPath(String var1, boolean var2);

    protected abstract String getScriptPath(String var1, boolean var2);

    protected abstract String getWinConsoleString();

    protected abstract void generateCommands(String var1, Collection var2);

    protected abstract void modifyScriptFileForDirectAttach(String var1, int var2, boolean var3, StringBuffer var4);

    protected abstract void modifyScriptFileForDynamicAttach(String var1, int var2, boolean var3, StringBuffer var4);

    protected String getDefaultScriptEncoding() {
        return null;
    }

    protected final void modifyScript(String originalScriptName, String modifiedScriptName, ProfilerScriptModifier modifier, AttachSettings attachSettings) throws ScriptModificationException {
        this.modifyScript(originalScriptName, modifiedScriptName, modifier, attachSettings, null);
    }

    protected final void modifyScript(String originalScriptName, String modifiedScriptName, ProfilerScriptModifier modifier, AttachSettings attachSettings, String encoding) throws ScriptModificationException {
        String targetOS = attachSettings.getHostOS();
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        BufferedReader br = null;
        File scriptFile = null;
        File modifiedScriptFile = null;
        try {
            String line;
            scriptFile = new File(originalScriptName);
            modifiedScriptFile = new File(modifiedScriptName);
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(scriptFile)) : new InputStreamReader((InputStream)new FileInputStream(scriptFile), encoding);
            if (encoding == null) {
                encoding = fr.getEncoding();
            }
            br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            StringBuffer lineBuffer = new StringBuffer();
            while ((line = br.readLine()) != null) {
                lineBuffer.append(line);
                modifier.lineRead(lineBuffer);
                buffer.append(lineBuffer);
                buffer.append(lineBreak);
                lineBuffer.delete(0, lineBuffer.length());
            }
            modifier.readDone();
            br.close();
            if (modifier.needsModification() && this.isBackupRequired() && !IntegrationUtils.backupFile((File)scriptFile)) {
                throw new ScriptModificationException("Can't backup script");
            }
            modifier.modifyScript(attachSettings, lineBreak, buffer);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(modifiedScriptFile), "UTF-8");
            fw.write(buffer.toString());
            ((Writer)fw).flush();
            ((Writer)fw).close();
            if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
                Runtime.getRuntime().exec("chmod a+x " + modifiedScriptFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            if (this.isBackupRequired() && !IntegrationUtils.restoreFile((File)scriptFile)) {
                throw new ScriptModificationException("Restore corrupted");
            }
            throw new ScriptModificationException(e);
        }
        catch (ScriptModificationException e) {
            if (this.isBackupRequired() && !IntegrationUtils.restoreFile((File)scriptFile)) {
                throw new ScriptModificationException("Restore corrupted", e);
            }
            throw e;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {}
        }
    }

    protected final void modifyScript(String originalScriptName, ProfilerScriptModifier modifier, AttachSettings attachSettings) throws ScriptModificationException {
        this.modifyScript(originalScriptName, originalScriptName, modifier, attachSettings);
    }

    private void generateCompleteCommands(String targetOS, Collection commandsArray) {
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            commandsArray.add("cmd.exe");
            commandsArray.add("/K");
            commandsArray.add("start");
            commandsArray.add("\"" + this.getWinConsoleString() + "\"");
        } else {
            if (IntegrationUtils.PLATFORM_MAC_OS.equals(targetOS)) {
                ArrayList startCommand = new ArrayList();
                StringBuffer startCommandBuffer = new StringBuffer(256);
                Iterator commandIt = startCommand.iterator();
                this.generateCommands(targetOS, startCommand);
                for (String args : startCommand) {
                    startCommandBuffer.append(args);
                    startCommandBuffer.append(" ");
                }
                commandsArray.add("/usr/bin/osascript");
                commandsArray.add("-e");
                commandsArray.add("tell Application \"Terminal\"");
                commandsArray.add("-e");
                commandsArray.add("do script \"" + startCommandBuffer + "\"");
                commandsArray.add("-e");
                commandsArray.add("end tell");
                return;
            }
            commandsArray.add("xterm");
            commandsArray.add("-sb");
            commandsArray.add("-sl");
            commandsArray.add("1000");
            commandsArray.add("-e");
        }
        this.generateCommands(targetOS, commandsArray);
    }

    private void modifyScriptForAttach(AttachSettings attachSettings) throws ScriptModificationException {
        final String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            this.modifyScript(this.getScriptPath(targetOS, false), this.getModifiedScriptPath(targetOS, false), new ProfilerScriptModifier(this.getHeaderModifier(targetOS)){

                @Override
                public void onModification(AttachSettings attachSettings, String lineBreak, StringBuffer scriptBuffer) throws ScriptModificationException {
                    AbstractScriptIntegrationProvider.this.modifyScriptFileForDirectAttach(targetOS, attachSettings.getPort(), false, scriptBuffer);
                }

                @Override
                public void onLineRead(StringBuffer line) {
                }
            }, attachSettings, this.getDefaultScriptEncoding());
        } else {
            this.modifyScript(this.getScriptPath(targetOS, false), this.getModifiedScriptPath(targetOS, false), new ProfilerScriptModifier(this.getHeaderModifier(targetOS)){

                @Override
                public void onModification(AttachSettings attachSettings, String lineBreak, StringBuffer scriptBuffer) throws ScriptModificationException {
                    AbstractScriptIntegrationProvider.this.modifyScriptFileForDynamicAttach(targetOS, attachSettings.getPort(), false, scriptBuffer);
                }

                @Override
                public void onLineRead(StringBuffer line) {
                }
            }, attachSettings, this.getDefaultScriptEncoding());
        }
    }

    private Collection prepareCommands(String targetOS) {
        ArrayList commandsArray = new ArrayList(15);
        this.generateCompleteCommands(targetOS, commandsArray);
        return commandsArray;
    }
}

