/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanelUI;
import org.netbeans.modules.profiler.attach.providers.RemotePackExporter;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;

public class ManualIntegrationPanel
extends AttachWizardPanel {
    AtomicBoolean exportRunning = new AtomicBoolean(false);
    private static final String HELP_CTX_KEY = "ManualIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ManualIntegrationPanel.HelpCtx");
    private ManualIntegrationPanelUI panel = null;
    private Model model = new Model();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return !this.exportRunning.get();
    }

    @Override
    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext context) {
        return this.isValid();
    }

    @Override
    public boolean canNext(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext context) {
    }

    @Override
    public void onExit(AttachWizardContext context) {
        this.model.setJvm(null);
    }

    @Override
    public void onFinish(AttachWizardContext context) {
        this.model.setJvm(null);
    }

    @Override
    public void onPanelShow() {
        this.panel.refresh();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ManualIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    class Model {
        private TargetPlatformEnum jvm = null;

        Model() {
        }

        public String getApplication() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getServerType();
        }

        public String getApplicationType() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().getTargetType();
        }

        public IntegrationProvider.IntegrationHints getIntegrationHints() {
            return ManualIntegrationPanel.this.getContext().getIntegrationProvider().getModificationHints(ManualIntegrationPanel.this.getContext().getAttachSettings());
        }

        public boolean isRemote() {
            return ManualIntegrationPanel.this.getContext().getAttachSettings().isRemote();
        }

        public void setJvm(TargetPlatformEnum jvm) {
            this.jvm = jvm;
            if (jvm != null) {
                ManualIntegrationPanel.this.getContext().getIntegrationProvider().setTargetJava(jvm.toString());
            }
        }

        public TargetPlatformEnum getJvm() {
            return this.jvm;
        }

        public List getSupportedJvms() {
            ArrayList<TargetPlatformEnum> supportedJvms = new ArrayList<TargetPlatformEnum>();
            if (ManualIntegrationPanel.this.getContext() != null) {
                AttachSettings settings = ManualIntegrationPanel.this.getContext().getAttachSettings();
                Iterator it = TargetPlatformEnum.iterator();
                while (it.hasNext()) {
                    TargetPlatformEnum jvm = (TargetPlatformEnum)it.next();
                    if (!settings.isDirect() && !settings.isRemote() && (!settings.isDynamic16() || !jvm.equals(TargetPlatformEnum.JDK6) && !jvm.equals(TargetPlatformEnum.JDK7)) || !ManualIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(jvm, settings)) continue;
                    supportedJvms.add(jvm);
                }
            }
            return supportedJvms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportRemotePack(String path) throws IOException {
            if (ManualIntegrationPanel.this.exportRunning.compareAndSet(false, true)) {
                try {
                    ManualIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
                    String string = RemotePackExporter.getInstance().export(path, ManualIntegrationPanel.this.getContext().getAttachSettings().getHostOS(), ManualIntegrationPanel.this.getContext().getIntegrationProvider().getTargetJava());
                    return string;
                }
                finally {
                    ManualIntegrationPanel.this.exportRunning.compareAndSet(true, false);
                    ManualIntegrationPanel.this.publishUpdate(new ChangeEvent(ManualIntegrationPanel.this.exportRunning));
                }
            }
            throw new IOException();
        }

        public String getRemotePackPath(String exportPath) {
            return RemotePackExporter.getInstance().getRemotePackPath(exportPath, ManualIntegrationPanel.this.getContext().getAttachSettings().getHostOS());
        }
    }
}

