/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.javadoc.DocPositions;
import org.netbeans.modules.java.editor.javadoc.JavaReference;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;

public final class JavadocImports {
    private static final Set<String> ALL_REF_TAG_NAMES = new HashSet<String>(Arrays.asList("@link", "@linkplain", "@value", "@see", "@throws"));

    private JavadocImports() {
    }

    public static Set<String> computeUnresolvedImports(CompilationInfo compilationInfo) {
        List list = compilationInfo.getTopLevelElements();
        UnresolvedImportScanner unresolvedImportScanner = new UnresolvedImportScanner(compilationInfo);
        unresolvedImportScanner.scan(list, null);
        return unresolvedImportScanner.unresolved;
    }

    public static Set<TypeElement> computeReferencedElements(CompilationInfo compilationInfo, TreePath treePath) {
        Set<TypeElement> set = null;
        Element element = compilationInfo.getTrees().getElement(treePath);
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, treePath.getLeaf(), element);
        if (element != null && tokenSequence != null) {
            List<Object> list;
            ElementKind elementKind = element.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element : compilationInfo.getElementUtilities().enclosingTypeElement(element);
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            DocPositions docPositions = null;
            if (doc != null && typeElement != null) {
                docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
                list = docPositions.getTags();
            } else {
                list = Collections.emptyList();
            }
            for (Tag tag : list) {
                DeclaredType declaredType;
                TypeElement typeElement2;
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, tokenSequence);
                if (javaReference == null || javaReference.fqn == null || javaReference.fqn.length() <= 0) continue;
                String string = ((Object)javaReference.fqn).toString();
                TypeMirror typeMirror = compilationInfo.getTreeUtilities().parseType(string, typeElement);
                if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED && typeMirror.getKind() != TypeKind.ERROR || !SourceVersion.isIdentifier((typeElement2 = (TypeElement)(declaredType = (DeclaredType)typeMirror).asElement()).getSimpleName())) continue;
                if (set == null) {
                    set = new HashSet<TypeElement>();
                }
                set.add(typeElement2);
            }
        }
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public static List<Token> computeTokensOfReferencedElements(CompilationInfo compilationInfo, TreePath treePath, Element element) {
        List<Token> list = null;
        Element element2 = compilationInfo.getTrees().getElement(treePath);
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, treePath.getLeaf(), element2);
        if (element2 != null && tokenSequence != null) {
            List<Object> list2;
            ElementKind elementKind = element2.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element2 : compilationInfo.getElementUtilities().enclosingTypeElement(element2);
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element2);
            DocPositions docPositions = null;
            if (doc != null && typeElement != null) {
                docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
                list2 = docPositions.getTags();
            } else {
                list2 = Collections.emptyList();
            }
            boolean bl = element.getKind() == ElementKind.PARAMETER;
            boolean bl2 = element.getKind() == ElementKind.TYPE_PARAMETER;
            for (Tag tag : list2) {
                Token<JavadocTokenId> token;
                int n;
                Element element3;
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, tokenSequence);
                if (javaReference != null) {
                    for (element3 = javaReference.getReferencedElement(compilationInfo, typeElement); element3 != null && element3 != element; element3 = element3.getEnclosingElement()) {
                    }
                    if (element3 != element) continue;
                    n = -1;
                    token = element3.getKind();
                    if (javaReference.fqn != null && (token.isClass() || token.isInterface())) {
                        String string = ((TypeElement)element3).getQualifiedName().toString();
                        String string2 = ((Object)javaReference.fqn).toString();
                        if (string2.startsWith(string)) {
                            n = javaReference.begin + string.length() - 1;
                        } else {
                            String string3 = element3.getSimpleName().toString();
                            n = javaReference.begin + string3.length() - 1;
                        }
                    } else if (token.isField() || token == ElementKind.METHOD || token == ElementKind.CONSTRUCTOR) {
                        n = javaReference.end - 1;
                    }
                    if (n < 0) continue;
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavadocTokenId.IDENT) continue;
                    if (list == null) {
                        list = new ArrayList<Token>();
                    }
                    list.add(tokenSequence.token());
                    continue;
                }
                if (!bl && !bl2 || tag == null || !"@param".equals(tag.name())) continue;
                element3 = (ParamTag)tag;
                n = bl && !element3.isTypeParameter() || bl2 && element3.isTypeParameter() ? 1 : 0;
                if (n == 0 || !element.getSimpleName().contentEquals(element3.parameterName()) || element != JavadocImports.paramElementFor(element2, (ParamTag)element3) || (token = JavadocImports.findNameTokenOfParamTag(tag, docPositions, tokenSequence)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Token>();
                }
                list.add(token);
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    private static Element paramElementFor(Element element, ParamTag paramTag) {
        Object object;
        ElementKind elementKind = element.getKind();
        List<Object> list = Collections.emptyList();
        if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
            object = (ExecutableElement)element;
            list = paramTag.isTypeParameter() ? object.getTypeParameters() : object.getParameters();
        } else if (elementKind.isClass() || elementKind.isInterface()) {
            object = (TypeElement)element;
            list = object.getTypeParameters();
        }
        for (Element element2 : list) {
            if (!element2.getSimpleName().contentEquals(paramTag.parameterName())) continue;
            return element2;
        }
        return null;
    }

    public static Element findReferencedElement(CompilationInfo compilationInfo, int n) {
        Element element = null;
        Document document = null;
        try {
            document = compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, n);
        if (tokenSequence != null) {
            JavaReference javaReference;
            Doc doc = JavadocCompletionUtils.findJavadoc(compilationInfo, document, n);
            if (doc == null) {
                return null;
            }
            DocPositions docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
            Element element2 = compilationInfo.getElementUtilities().elementFor(doc);
            if (docPositions == null || element2 == null) {
                return null;
            }
            ElementKind elementKind = element2.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element2 : compilationInfo.getElementUtilities().enclosingTypeElement(element2);
            Tag tag = docPositions.getTag(n);
            JavaReference javaReference2 = javaReference = tag != null ? JavadocImports.findReference(tag, docPositions, tokenSequence) : null;
            if (javaReference != null && typeElement != null) {
                element = javaReference.getReferencedElement(compilationInfo, typeElement);
                if (element != null && javaReference.fqn != null && n < javaReference.begin + javaReference.fqn.length()) {
                    element = element.getKind().isClass() || element.getKind().isInterface() ? element : element.getEnclosingElement();
                    int n2 = element.getSimpleName().length();
                    while (element != null && n < javaReference.begin + javaReference.fqn.length() - n2) {
                        n2 += (element = element.getEnclosingElement()) != null ? element.getSimpleName().length() + 1 : 0;
                    }
                }
            } else if (tag instanceof ParamTag && "@param".equals(tag.name())) {
                ParamTag paramTag = (ParamTag)tag;
                element = JavadocImports.paramElementFor(element2, paramTag);
            }
        }
        return element;
    }

    public static Token findNameTokenOfReferencedElement(CompilationInfo compilationInfo, int n) {
        Document document = null;
        try {
            document = compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, n);
        if (tokenSequence != null) {
            JavaReference javaReference;
            Doc doc = JavadocCompletionUtils.findJavadoc(compilationInfo, document, n);
            if (doc == null) {
                return null;
            }
            DocPositions docPositions = DocPositions.get(compilationInfo, doc, tokenSequence);
            Element element = compilationInfo.getElementUtilities().elementFor(doc);
            if (docPositions == null || element == null) {
                return null;
            }
            ElementKind elementKind = element.getKind();
            TypeElement typeElement = elementKind.isClass() || elementKind.isInterface() ? (TypeElement)element : compilationInfo.getElementUtilities().enclosingTypeElement(element);
            Tag tag = docPositions.getTag(n);
            JavaReference javaReference2 = javaReference = tag != null ? JavadocImports.findReference(tag, docPositions, tokenSequence) : null;
            if (javaReference != null && typeElement != null) {
                Element element2 = javaReference.getReferencedElement(compilationInfo, typeElement);
                if (element2 != null) {
                    int n2;
                    int n3 = n2 = javaReference.fqn != null ? javaReference.fqn.length() : 0;
                    if (javaReference.fqn != null && n >= javaReference.begin && n < javaReference.begin + n2 || javaReference.member != null && n > javaReference.begin + n2 && n < javaReference.end) {
                        tokenSequence.move(n);
                        if (tokenSequence.moveNext()) {
                            return tokenSequence.token().id() == JavadocTokenId.IDENT ? tokenSequence.token() : null;
                        }
                    }
                }
            } else {
                Token<JavadocTokenId> token = JavadocImports.findNameTokenOfParamTag(tag, docPositions, tokenSequence);
                return token;
            }
        }
        return null;
    }

    private static Token<JavadocTokenId> findNameTokenOfParamTag(Tag tag, DocPositions docPositions, TokenSequence<JavadocTokenId> tokenSequence) {
        if (tag == null || !"@param".equals(tag.name())) {
            return null;
        }
        ParamTag paramTag = (ParamTag)tag;
        int[] nArray = docPositions.getTagSpan(tag);
        Token token = null;
        if (paramTag.isTypeParameter()) {
            tokenSequence.move(nArray[0]);
            if (tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.TAG && tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.OTHER_TEXT && tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.HTML_TAG) {
                token = tokenSequence.token();
            }
        } else {
            tokenSequence.move(nArray[0]);
            if (tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.TAG && tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.OTHER_TEXT && tokenSequence.moveNext() && tokenSequence.token().id() == JavadocTokenId.IDENT) {
                token = tokenSequence.token();
            }
        }
        return token;
    }

    public static boolean isInsideReference(TokenSequence<JavadocTokenId> tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && JavadocTokenId.IDENT == tokenSequence.token().id()) {
            boolean bl = false;
            block6: while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                switch ((JavadocTokenId)token.id()) {
                    case DOT: 
                    case HASH: 
                    case IDENT: {
                        if (!bl) continue block6;
                        return false;
                    }
                    case OTHER_TEXT: {
                        bl |= JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)token);
                        if (bl |= JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token)) continue block6;
                        return false;
                    }
                    case TAG: {
                        return bl && JavadocImports.isReferenceTag((Token<JavadocTokenId>)token);
                    }
                    case HTML_TAG: {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isInsideParamName(TokenSequence<JavadocTokenId> tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && (JavadocTokenId.IDENT == tokenSequence.token().id() || JavadocTokenId.HTML_TAG == tokenSequence.token().id()) && tokenSequence.movePrevious() && JavadocTokenId.OTHER_TEXT == tokenSequence.token().id() && tokenSequence.movePrevious() && JavadocTokenId.TAG == tokenSequence.token().id()) {
            return "@param".contentEquals(tokenSequence.token().text());
        }
        return false;
    }

    private static JavaReference findReference(Tag tag, DocPositions docPositions, TokenSequence<JavadocTokenId> tokenSequence) {
        if (tag == null || !JavadocImports.isReferenceTag(tag)) {
            return null;
        }
        int[] nArray = docPositions.getTagSpan(tag);
        tokenSequence.move(nArray[0] + (JavadocCompletionUtils.isBlockTag(tag) ? 0 : 1));
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavadocTokenId.TAG) {
            return null;
        }
        if (!tokenSequence.moveNext() || !JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)tokenSequence.token()) && !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)tokenSequence.token()) || !tokenSequence.moveNext()) {
            return null;
        }
        return JavaReference.resolve(tokenSequence, tokenSequence.offset(), nArray[1]);
    }

    private static boolean isReferenceTag(Tag tag) {
        String string = tag.name();
        return ALL_REF_TAG_NAMES.contains(string.intern());
    }

    private static boolean isReferenceTag(Token<JavadocTokenId> token) {
        String string = ((Object)token.text()).toString().intern();
        return token.id() == JavadocTokenId.TAG && ALL_REF_TAG_NAMES.contains(string);
    }

    private static final class UnresolvedImportScanner
    extends ElementScanner6<Void, Void> {
        private final CompilationInfo javac;
        private Set<String> unresolved = new HashSet<String>();

        public UnresolvedImportScanner(CompilationInfo compilationInfo) {
            this.javac = compilationInfo;
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, Void void_) {
            TypeElement typeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)executableElement);
            if (typeElement != null) {
                this.resolveElement(executableElement, typeElement);
            }
            return (Void)super.visitExecutable(executableElement, void_);
        }

        @Override
        public Void visitType(TypeElement typeElement, Void void_) {
            this.resolveElement(typeElement, typeElement);
            return (Void)super.visitType(typeElement, void_);
        }

        @Override
        public Void visitVariable(VariableElement variableElement, Void void_) {
            TypeElement typeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)variableElement);
            if (typeElement != null) {
                this.resolveElement(variableElement, typeElement);
            }
            return (Void)super.visitVariable(variableElement, void_);
        }

        private void resolveElement(Element element, TypeElement typeElement) {
            String string = this.javac.getElements().getDocComment(element);
            if (string != null) {
                DocPositions docPositions;
                Doc doc = this.javac.getElementUtilities().javaDocFor(element);
                TokenSequence<JavadocTokenId> tokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(this.javac, null, element);
                if (tokenSequence != null && (docPositions = DocPositions.get(this.javac, doc, tokenSequence)) != null) {
                    this.resolveTags(docPositions, tokenSequence, typeElement);
                }
            }
        }

        private void resolveTags(DocPositions docPositions, TokenSequence<JavadocTokenId> tokenSequence, TypeElement typeElement) {
            for (Tag tag : docPositions.getTags()) {
                JavaReference javaReference = JavadocImports.findReference(tag, docPositions, (TokenSequence<JavadocTokenId>)tokenSequence);
                if (javaReference == null || javaReference.fqn == null || javaReference.fqn.length() <= 0) continue;
                String string = ((Object)javaReference.fqn).toString();
                TypeMirror typeMirror = this.javac.getTreeUtilities().parseType(string, typeElement);
                if (typeMirror == null || typeMirror.getKind() != TypeKind.ERROR) continue;
                this.unresolved.add(string);
            }
        }
    }
}

