/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.hyperlink;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.java.editor.overridden.GoToImplementation;

public final class JavaHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION, HyperlinkType.ALT_HYPERLINK);
    }

    public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
        return this.getHyperlinkSpan(document, n, hyperlinkType) != null;
    }

    public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
        return GoToSupport.getIdentifierSpan(document, n, null);
    }

    public void performClickAction(Document document, int n, HyperlinkType hyperlinkType) {
        switch (hyperlinkType) {
            case GO_TO_DECLARATION: {
                GoToSupport.goTo(document, n, false);
                break;
            }
            case ALT_HYPERLINK: {
                JTextComponent jTextComponent = EditorRegistry.focusedComponent();
                if (jTextComponent.getDocument() != document) break;
                jTextComponent.setCaretPosition(n);
                GoToImplementation.goToImplementation(jTextComponent);
            }
        }
    }

    public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
        return GoToSupport.getGoToElementTooltip(document, n, false, hyperlinkType == HyperlinkType.GO_TO_DECLARATION ? "TP_OverriddenTooltipSugg" : "TP_GoToOverriddenTooltipSugg");
    }
}

