/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.ini;

import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.ini.IniTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

class IniLexer
implements Lexer<IniTokenId> {
    private static final char ESCAPE = '\\';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char COMMENT = ';';
    private static final char SECTION_START = '[';
    private static final char SECTION_END = ']';
    private static final char EQUALS = '=';
    private static final char LONG_STRING_DOUBLE = '\"';
    private static final char LONG_STRING_SINGLE = '\'';
    private final LexerRestartInfo<IniTokenId> info;
    private State state = State.START;

    IniLexer(LexerRestartInfo<IniTokenId> info) {
        this.info = info;
        State startState = (State)((Object)info.state());
        if (startState != null) {
            this.state = startState;
        }
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    public Token<IniTokenId> nextToken() {
        LexerInput input = this.info.input();
        int ch = input.read();
        if (ch == -1) {
            return null;
        }
        input.backup(1);
        if (this.state.equals((Object)State.START)) {
            this.state = ch == 59 ? State.COMMENT : (IniLexer.isWhiteSpace(ch) ? State.WHITESPACE : State.NAME);
        }
        switch (this.state) {
            case WHITESPACE: 
            case WHITESPACE_AFTER_NAME: 
            case WHITESPACE_AFTER_EQUALS: {
                boolean newLine = this.readWhitespace(input);
                if (newLine) {
                    this.state = State.START;
                } else {
                    switch (this.state) {
                        case WHITESPACE: {
                            this.state = State.START;
                            break;
                        }
                        case WHITESPACE_AFTER_NAME: {
                            this.state = State.EQUALS;
                            break;
                        }
                        case WHITESPACE_AFTER_EQUALS: {
                            this.state = State.VALUE;
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled state: " + (Object)((Object)this.state);
                            break;
                        }
                    }
                }
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.WHITESPACE);
            }
            case COMMENT: {
                this.readTillEndLine(input, false);
                this.state = State.WHITESPACE;
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.COMMENT);
            }
            case NAME: {
                if (ch == 91 && (ch = this.readTillEndLine(input, ']', ';')) == 93) {
                    input.read();
                    this.state = State.START;
                    int read = input.readLength();
                    ch = this.readTillEndLine(input, ';');
                    int readNext = input.readLength();
                    int diff = readNext - read;
                    if (diff > 0) {
                        String error = ((Object)input.readText(0, readNext)).toString().substring(read).trim();
                        if (!error.isEmpty()) {
                            this.state = State.ERROR;
                        }
                        input.backup(diff);
                    }
                    return this.info.tokenFactory().createToken((TokenId)IniTokenId.SECTION);
                }
                input.backup(input.readLength());
                ch = this.readTillEndLine(input, '=', ';');
                if (ch == 59) {
                    this.processComment(input);
                } else if (ch == 61) {
                    String name = ((Object)input.readText(0, input.readLength())).toString();
                    String trimmed = name.replaceAll("\\s+$", "");
                    int backup = name.length() - trimmed.length();
                    if (backup > 0) {
                        this.state = State.WHITESPACE_AFTER_NAME;
                        input.backup(backup);
                    } else {
                        this.state = State.EQUALS;
                    }
                } else {
                    this.state = State.START;
                }
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.NAME);
            }
            case EQUALS: {
                assert (ch == 61) : "Unexpected char: " + (char)ch;
                ch = input.read();
                assert (ch == 61) : "Unexpected char: " + (char)ch;
                ch = input.read();
                this.state = IniLexer.isWhiteSpace(ch) ? State.WHITESPACE_AFTER_EQUALS : (ch == 59 ? State.COMMENT : State.VALUE);
                input.backup(1);
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.EQUALS);
            }
            case VALUE: {
                ch = this.readTillEndLine(input, ';');
                if (ch == 59) {
                    this.processComment(input);
                } else {
                    this.state = State.WHITESPACE;
                }
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.VALUE);
            }
            case ERROR: {
                ch = this.readTillEndLine(input, ';');
                if (ch == 59) {
                    this.processComment(input);
                } else {
                    this.state = State.START;
                }
                return this.info.tokenFactory().createToken((TokenId)IniTokenId.ERROR);
            }
        }
        assert (false) : "Unknown state: " + (Object)((Object)this.state);
        assert (false) : "Should not get here";
        return null;
    }

    private void processComment(LexerInput input) {
        String read = ((Object)input.readText(0, input.readLength())).toString();
        String trimmed = read.replaceAll("\\s+$", "");
        int backup = read.length() - trimmed.length();
        if (backup > 0) {
            this.state = State.WHITESPACE;
            input.backup(backup);
        } else {
            this.state = State.COMMENT;
        }
    }

    private boolean readWhitespace(LexerInput input) {
        int ch;
        boolean newLine = false;
        do {
            ch = input.read();
            if (newLine || !IniLexer.isEndLine(ch)) continue;
            newLine = true;
        } while (IniLexer.isWhiteSpace(ch) && ch != -1);
        input.backup(1);
        return newLine;
    }

    private int readTillEndLine(LexerInput input) {
        return this.readTillEndLine(input, null);
    }

    private int readTillEndLine(LexerInput input, boolean handleLongStrings) {
        return this.readTillEndLine(input, handleLongStrings, null);
    }

    private int readTillEndLine(LexerInput input, char ... stoppers) {
        return this.readTillEndLine(input, true, stoppers);
    }

    private int readTillEndLine(LexerInput input, boolean handleLongStrings, char ... stoppers) {
        int ch = -1;
        int previous = -1;
        LinkedList<Character> longStringsStack = new LinkedList<Character>();
        do {
            if (previous == 92 && ch == 92) {
                previous = -1;
            } else if (ch != -1) {
                previous = ch;
            }
            ch = input.read();
            if (ch == -1) break;
            if (!handleLongStrings || previous == 92) continue;
            this.handleLongStrings(longStringsStack, (char)ch);
        } while (!longStringsStack.isEmpty() || longStringsStack.isEmpty() && !IniLexer.isEndLine(ch) && !this.isStopper(stoppers, ch, previous));
        input.backup(1);
        return ch;
    }

    private void handleLongStrings(LinkedList<Character> longStringsStack, char ch) {
        if (ch != '\"' && ch != '\'') {
            return;
        }
        if (longStringsStack.isEmpty()) {
            longStringsStack.push(Character.valueOf(ch));
        } else {
            Character peek = longStringsStack.peek();
            if (peek.charValue() == ch) {
                longStringsStack.pop();
            } else {
                longStringsStack.push(Character.valueOf(ch));
            }
        }
    }

    private boolean isStopper(char[] stoppers, int ch, int previous) {
        if (stoppers == null || previous == 92) {
            return false;
        }
        for (char stopper : stoppers) {
            if (stopper != ch) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhiteSpace(int ch) {
        return ch == 32 || ch == 9 || IniLexer.isEndLine(ch);
    }

    private static boolean isEndLine(int ch) {
        return ch == 10 || ch == 13 || ch == -1;
    }

    private static enum State {
        START,
        COMMENT,
        NAME,
        EQUALS,
        VALUE,
        ERROR,
        WHITESPACE,
        WHITESPACE_AFTER_NAME,
        WHITESPACE_AFTER_EQUALS;

    }
}

