/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;

class InterfaceScopeImpl
extends TypeScopeImpl
implements InterfaceScope {
    InterfaceScopeImpl(Scope inScope, InterfaceDeclarationInfo nodeInfo) {
        super(inScope, nodeInfo);
    }

    InterfaceScopeImpl(IndexScope inScope, InterfaceElement indexedIface) {
        super((Scope)inScope, indexedIface);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Collection implementedInterfaces = this.getSuperInterfaceScopes();
        if (implementedInterfaces.size() > 0) {
            sb.append(" implements ");
            for (InterfaceScope interfaceScope : implementedInterfaces) {
                sb.append(interfaceScope.getName()).append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
            }
            case SuperTypes: {
                Set<QualifiedName> superIfaces = this.getSuperInterfaces();
                if (!superIfaces.isEmpty()) {
                    retval.append(" extends ");
                }
                StringBuilder ifacesBuffer = new StringBuilder();
                for (QualifiedName qualifiedName : superIfaces) {
                    if (ifacesBuffer.length() > 0) {
                        ifacesBuffer.append(", ");
                    }
                    ifacesBuffer.append(qualifiedName.getName());
                }
                retval.append((CharSequence)ifacesBuffer);
            }
        }
        return retval.toString();
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        HashSet<MethodScopeImpl> allMethods = new HashSet<MethodScopeImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet interfaceScopes = new HashSet();
        interfaceScopes.addAll(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<MethodElement> indexedFunctions = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(iface));
            for (MethodElement classMember : indexedFunctions) {
                MethodElement indexedFunction = classMember;
                TypeElement type = indexedFunction.getType();
                if (type.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type), indexedFunction));
            }
        }
        return allMethods;
    }

    @Override
    public final Collection<? extends ClassConstantElement> getInheritedConstants() {
        HashSet<ClassConstantElementImpl> allConstants = new HashSet<ClassConstantElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet interfaceScopes = new HashSet();
        interfaceScopes.addAll(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<TypeConstantElement> indexedConstants = index.getInheritedTypeConstants(iface);
            Iterator i$ = indexedConstants.iterator();
            while (i$.hasNext()) {
                TypeConstantElement classMember;
                TypeConstantElement indexedFunction = classMember = (TypeConstantElement)i$.next();
                allConstants.add(new ClassConstantElementImpl((Scope)iface, indexedFunction));
            }
        }
        return allConstants;
    }

    @Override
    public final Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> allMethods = new HashSet<MethodScope>();
        allMethods.addAll(this.getDeclaredMethods());
        allMethods.addAll(this.getInheritedMethods());
        return allMethods;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(";");
        sb.append(this.getName()).append(";");
        sb.append(this.getOffset()).append(";");
        Collection superInterfaces = this.getSuperInterfaceNames();
        for (int i = 0; i < superInterfaces.size(); ++i) {
            String iface = (String)superInterfaces.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(iface);
        }
        sb.append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(";");
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof InterfaceElement) {
            InterfaceElement indexedInterface = (InterfaceElement)this.indexedElement;
            return indexedInterface.getNamespaceName();
        }
        return super.getNamespaceName();
    }
}

