/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class VariableElementImpl
extends PhpElementImpl
implements VariableElement {
    public static final String DOLLAR_PREFIX = "$";
    public static final String REFERENCE_PREFIX = "&";
    public static final String IDX_FIELD = "var";
    private final Set<TypeResolver> instanceTypes;

    protected VariableElementImpl(String variableName, int offset, String fileUrl, ElementQuery elementQuery, Set<TypeResolver> instanceTypes) {
        super(VariableElementImpl.getName(variableName, true), null, fileUrl, offset, elementQuery);
        this.instanceTypes = instanceTypes;
    }

    public static VariableElementImpl create(String variableName, int offset, String fileUrl, ElementQuery elementQuery, Set<TypeResolver> instanceTypes) {
        return new VariableElementImpl(variableName, offset, fileUrl, elementQuery, instanceTypes);
    }

    public static VariableElementImpl create(String variableName, int offset, final FileObject fileObject, ElementQuery elementQuery, Set<TypeResolver> instanceTypes) {
        return new VariableElementImpl(variableName, offset, null, elementQuery, instanceTypes){

            @Override
            public synchronized FileObject getFileObject() {
                return fileObject;
            }
        };
    }

    public static Set<VariableElement> fromSignature(IndexQueryImpl indexQuery, IndexResult indexResult) {
        return VariableElementImpl.fromSignature(NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<VariableElement> fromSignature(NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<VariableElement> retval = values.length > 0 ? new HashSet<VariableElement>() : Collections.emptySet();
        for (String val : values) {
            VariableElement var = VariableElementImpl.fromSignature(query, indexQuery, indexResult, Signature.get(val));
            if (var == null) continue;
            retval.add(var);
        }
        return retval;
    }

    public static VariableElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature sig) {
        VariableSignatureParser signParser = new VariableSignatureParser(sig);
        VariableElementImpl retval = null;
        if (VariableElementImpl.matchesQuery(query, signParser)) {
            retval = new VariableElementImpl(signParser.getVariableName(), signParser.getOffset(), indexResult.getUrl().toString(), indexScopeQuery, signParser.getTypes());
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, VariableSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(VariableElement.KIND, signParser.getVariableName());
    }

    @Override
    public final String getName(boolean dollared) {
        String name = this.getName();
        boolean startsWithDollar = name.startsWith(DOLLAR_PREFIX);
        if (startsWithDollar == dollared) {
            return name;
        }
        return dollared ? String.format("%s%s", DOLLAR_PREFIX, name) : name.substring(1);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        String varName = this.getName();
        sb.append(varName.toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(varName).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return VariableElement.KIND;
    }

    @Override
    public final Set<TypeResolver> getInstanceTypes() {
        return this.instanceTypes;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            VariableSignatureParser parser = new VariableSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getVariableName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getInstanceTypes().size() == parser.getTypes().size());
        }
    }

    private static String getName(String name, boolean dollared) {
        boolean startsWithDollar = name.startsWith(DOLLAR_PREFIX);
        if (startsWithDollar == dollared) {
            return name;
        }
        return dollared ? String.format("%s%s", DOLLAR_PREFIX, name) : name.substring(1);
    }

    private static String toName(Variable node) {
        return CodeUtils.extractVariableName(node);
    }

    private static OffsetRange toOffsetRange(Variable node) {
        Expression name = node.getName();
        while (name instanceof Variable) {
            while (name instanceof ArrayAccess) {
                ArrayAccess access = (ArrayAccess)name;
                name = access.getName();
            }
            if (!(name instanceof Variable)) continue;
            Variable var = (Variable)name;
            name = var.getName();
        }
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    private static class VariableSignatureParser {
        private final Signature signature;

        VariableSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getVariableName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(3);
        }

        Set<TypeResolver> getTypes() {
            return TypeResolverImpl.parseTypes(this.signature.string(2));
        }
    }
}

