/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.util.Arrays;
import java.util.MissingResourceException;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelectorBuilder;
import org.netbeans.modules.bugtracking.util.ConnectorComparator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SelectorPanel {
    private RepositorySelectorBuilder builder = new RepositorySelectorBuilder();
    private final String comboLabelText = NbBundle.getMessage(SelectorPanel.class, (String)"SelectorPanel.connectorLabel.text");

    boolean open() {
        String title = this.createOpenDescriptor();
        DialogDescriptor dd = this.builder.createDialogDescriptor(title);
        boolean ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION;
        return ret;
    }

    boolean edit(Repository repository, String errorMessage) {
        DialogDescriptor dd = this.createEditDescriptor(repository, errorMessage);
        boolean ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION;
        return ret;
    }

    private String createOpenDescriptor() throws MissingResourceException {
        String title = NbBundle.getMessage(SelectorPanel.class, (String)"CTL_CreateTitle");
        this.builder.setLabelText(this.comboLabelText);
        this.builder.setBugtrackingConnectorDisplayFormat("{0}");
        return title;
    }

    private DialogDescriptor createEditDescriptor(Repository repository, String errorMessage) throws MissingResourceException {
        String title = NbBundle.getMessage(SelectorPanel.class, (String)"CTL_EditTitle");
        this.builder.setLabelVisible(false);
        this.builder.setComboBoxVisible(false);
        this.builder.setPreselectedRepository(repository);
        this.builder.setInitialErrorMessage(errorMessage);
        DialogDescriptor dd = this.builder.createDialogDescriptor(title);
        return dd;
    }

    Repository getRepository() {
        return this.builder.getSelectedRepository();
    }

    void setConnectors(BugtrackingConnector[] connectors) {
        Arrays.sort(connectors, new ConnectorComparator());
        this.builder.setBugtrackingConnectors(connectors);
    }
}

