/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class HelpCtxProcessor
implements XMLDataObject.Processor,
InstanceCookie.Of {
    private XMLDataObject xml;
    private Action p;

    private static Help findHelp() {
        return (Help)Lookup.getDefault().lookup(Help.class);
    }

    public void attachTo(XMLDataObject xml) {
        this.xml = xml;
        Installer.log.fine("processing help context ref: " + xml.getPrimaryFile());
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return ShortcutAction.class;
    }

    public String instanceName() {
        return "org.netbeans.modules.javahelp.HelpCtxProcessor$ShortcutAction";
    }

    public boolean instanceOf(Class type) {
        return type == Action.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.p != null) {
            return this.p;
        }
        Installer.log.fine("creating help context presenter from " + this.xml.getPrimaryFile());
        EntityResolver resolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        };
        HandlerBase handler = new HandlerBase(){

            @Override
            public void startElement(String name, AttributeList amap) throws SAXException {
                if ("helpctx".equals(name)) {
                    String id = amap.getValue("id");
                    String showmaster = amap.getValue("showmaster");
                    if (id != null && !"".equals(id)) {
                        HelpCtxProcessor.this.p = new ShortcutAction(HelpCtxProcessor.this.xml, id, Boolean.valueOf(showmaster));
                    }
                }
            }
        };
        HelpCtxProcessor helpCtxProcessor = this;
        Parser parser = helpCtxProcessor.xml.createParser();
        parser.setEntityResolver(resolver);
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(this.xml.getPrimaryFile().getInputStream()));
        }
        catch (SAXException saxe) {
            throw (IOException)new IOException(saxe.toString()).initCause(saxe);
        }
        if (this.p == null) {
            throw new IOException("No <helpctx> element in " + this.xml.getPrimaryFile());
        }
        return this.p;
    }

    private static final class ShortcutAction
    extends AbstractAction
    implements HelpCtx.Provider,
    NodeListener,
    ChangeListener {
        private final XMLDataObject obj;
        private String helpID;
        private boolean showmaster;

        public ShortcutAction(XMLDataObject obj, String helpID, boolean showmaster) {
            Help h;
            this.obj = obj;
            this.helpID = helpID;
            this.showmaster = showmaster;
            this.putValue("noIconInMenu", Boolean.TRUE);
            Installer.log.fine("new ShortcutAction: " + obj + " " + helpID + " showmaster=" + showmaster);
            this.updateText();
            this.updateIcon();
            this.updateEnabled();
            if (obj.isValid()) {
                Node n = obj.getNodeDelegate();
                n.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)n));
            }
            if ((h = HelpCtxProcessor.findHelp()) != null) {
                h.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)h));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Help h = HelpCtxProcessor.findHelp();
            if (h != null) {
                Installer.log.fine("ShortcutAction.actionPerformed: " + this.helpID + " showmaster=" + this.showmaster);
                h.showHelp(new HelpCtx(this.helpID), this.showmaster);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("ide.welcome");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateEnabled();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (!this.obj.isValid()) {
                return;
            }
            if (prop == null || prop.equals("name") || prop.equals("displayName")) {
                this.updateText();
            }
            if (prop == null || prop.equals("icon")) {
                this.updateIcon();
            }
        }

        private void updateText() {
            String text = this.obj.isValid() ? this.obj.getNodeDelegate().getDisplayName() : "dead";
            this.putValue("Name", text);
        }

        private void updateIcon() {
            Image icon;
            if (this.obj.isValid() && (icon = this.obj.getNodeDelegate().getIcon(1)) != null) {
                this.putValue("SmallIcon", new ImageIcon(icon));
            }
        }

        private void updateEnabled() {
            Boolean valid;
            Help h = HelpCtxProcessor.findHelp();
            Boolean bl = valid = h == null ? Boolean.FALSE : h.isValidID(this.helpID, false);
            if (valid != null) {
                this.setEnabled(valid);
            }
            Installer.log.fine("enabled: xml=" + this.obj.getPrimaryFile() + " id=" + this.helpID + " enabled=" + valid);
        }

        public void nodeDestroyed(NodeEvent ev) {
            this.setEnabled(false);
            this.updateText();
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }
    }
}

