/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPresenter;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.inspector.InspectorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.inspector.FolderRegistry;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.netbeans.modules.vmd.inspector.InspectorUI;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.NewType;

public final class InspectorWrapperTree
implements FolderRegistry.Listener {
    private Collection<InspectorFolder> globalFolders;
    private FolderRegistry registry;
    private DesignDocument document;
    private InspectorFolderWrapper rootFolderWrapper;
    private Collection<DesignComponent> componentsToDelete;
    private Collection<DesignComponent> componentsToAdd;
    private Collection<DesignComponent> componentsToUndo;
    private Collection<InspectorFolderWrapper> foldersToUpdate;
    private Collection<DesignComponent> deletedComponentsCash;
    private Collection<InspectorFolderWrapper> foldersToExtend = new WeakSet();
    private boolean lock = true;
    private InspectorUI ui;

    InspectorWrapperTree(DesignDocument document, InspectorUI ui) {
        this.foldersToUpdate = new WeakSet();
        this.componentsToAdd = new WeakSet();
        this.componentsToDelete = new WeakSet();
        this.componentsToUndo = new WeakSet();
        this.document = document;
        this.rootFolderWrapper = new InspectorFolderWrapper(document, new RootFolder());
        this.rootFolderWrapper.resolveFolder(document);
        assert (ui != null);
        this.ui = ui;
    }

    synchronized void buildTree(final DesignEvent event) {
        this.lock = true;
        this.document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (InspectorWrapperTree.this.rootFolderWrapper.getChildren() != null && event != null) {
                    if (event.getFullyAffectedComponents() != null && !event.getFullyAffectedComponents().isEmpty()) {
                        InspectorWrapperTree.this.addFoldersToUpdate(event.getFullyAffectedComponents(), InspectorWrapperTree.this.rootFolderWrapper);
                    }
                    InspectorWrapperTree.this.updateChangedDescriptors(event.getCreatedComponents(), event.getFullyAffectedComponents());
                    InspectorWrapperTree.this.dive(InspectorFolderPath.createInspectorPath().add(InspectorWrapperTree.this.rootFolderWrapper.getFolder()), InspectorWrapperTree.this.rootFolderWrapper);
                    InspectorWrapperTree.this.updateTreeStructureView();
                    InspectorWrapperTree.this.ui.expandNodes(InspectorWrapperTree.this.foldersToExtend);
                } else {
                    InspectorWrapperTree.this.updateChangedDescriptors(InspectorWrapperTree.this.markAllComponentsAsToAdd(), null);
                    InspectorWrapperTree.this.dive(InspectorFolderPath.createInspectorPath().add(InspectorWrapperTree.this.rootFolderWrapper.getFolder()), InspectorWrapperTree.this.rootFolderWrapper);
                    InspectorWrapperTree.this.updateTreeStructureView();
                    List<InspectorFolderWrapper> foldersToExpand = InspectorWrapperTree.this.rootFolderWrapper.getChildren();
                    if (foldersToExpand != null && InspectorWrapperTree.this.ui != null) {
                        InspectorWrapperTree.this.ui.expandNodes(foldersToExpand);
                    }
                }
            }
        });
        this.foldersToUpdate.clear();
        this.foldersToExtend.clear();
        this.componentsToAdd.clear();
        this.componentsToDelete.clear();
        this.componentsToUndo.clear();
        this.lock = false;
    }

    private void addFoldersToUpdate(Collection<DesignComponent> fullyAffected, InspectorFolderWrapper parentWrapper) {
        if (parentWrapper.getChildren() == null) {
            return;
        }
        for (InspectorFolderWrapper wrapper : parentWrapper.getChildren()) {
            this.addFoldersToUpdate(fullyAffected, wrapper);
            if (!fullyAffected.contains(wrapper.getComponent())) continue;
            this.foldersToUpdate.add(wrapper);
        }
    }

    boolean isLocked() {
        return this.lock;
    }

    private void dive(InspectorFolderPath path, InspectorFolderWrapper parentWrapper) {
        List<InspectorFolderWrapper> wrapperChildren = parentWrapper.getFolder() instanceof RootFolder ? this.componentsRecursion(path, parentWrapper, this.document.getRootComponent()) : this.componentsChildrenDive(path, parentWrapper, this.document.getRootComponent());
        if (wrapperChildren == null) {
            wrapperChildren = this.registryDescriptorsDive(path, parentWrapper);
        } else {
            List<InspectorFolderWrapper> registryWrapperChildren = this.registryDescriptorsDive(path, parentWrapper);
            if (registryWrapperChildren != null) {
                wrapperChildren.addAll(registryWrapperChildren);
            }
        }
        if (wrapperChildren == null) {
            wrapperChildren = parentWrapper.getChildren();
        } else {
            this.foldersToUpdate.add(parentWrapper);
            List<InspectorFolderWrapper> parentWrapperChildren = parentWrapper.getChildren();
            if (parentWrapperChildren != null) {
                wrapperChildren.addAll(parentWrapperChildren);
            }
        }
        if (wrapperChildren != null) {
            Collection wrappersToDelete = null;
            for (InspectorFolderWrapper folder : wrapperChildren) {
                if (this.componentsToDelete != null && folder != null && folder.getFolder() != null && folder.getFolder().getComponentID() != null) {
                    for (DesignComponent component : this.componentsToDelete) {
                        if (!folder.getFolder().getComponentID().equals(component.getComponentID())) continue;
                        if (wrappersToDelete == null) {
                            wrappersToDelete = new WeakSet();
                        }
                        wrappersToDelete.add(folder);
                        if (this.deletedComponentsCash == null) {
                            this.deletedComponentsCash = new WeakSet();
                        }
                        this.deletedComponentsCash.add(this.document.getComponentByUID(component.getComponentID()));
                        this.foldersToUpdate.add(parentWrapper);
                    }
                }
                path.add(folder.getFolder());
                this.dive(path, folder);
                path.remove(folder.getFolder());
            }
            if (wrappersToDelete != null) {
                wrapperChildren.removeAll(wrappersToDelete);
                for (InspectorFolderWrapper wrapperToDelete : wrappersToDelete) {
                    wrapperToDelete.terminate();
                }
            }
            parentWrapper.setChildren(wrapperChildren);
        }
    }

    private List<InspectorFolderWrapper> componentsChildrenDive(InspectorFolderPath path, InspectorFolderWrapper parentWrapper, DesignComponent parentComponent) {
        List<InspectorFolderWrapper> wrapperChildren = null;
        for (DesignComponent component : parentComponent.getComponents()) {
            if (this.componentsToAdd.contains(component) || this.componentsToUndo.contains(component)) {
                List<InspectorFolderWrapper> tempWrapperChildren = this.componentsRecursion(path, parentWrapper, component);
                if (wrapperChildren == null) {
                    wrapperChildren = tempWrapperChildren;
                } else if (tempWrapperChildren != null) {
                    wrapperChildren.addAll(tempWrapperChildren);
                }
            }
            if (!InspectorRegistry.getInstance(this.document).getComponentsToUpdate().isEmpty() && InspectorRegistry.getInstance(this.document).getComponentsToUpdate().contains(component)) {
                if (wrapperChildren == null) {
                    wrapperChildren = this.changedComponentsRecursion(path, parentWrapper, component);
                } else {
                    List<InspectorFolderWrapper> changedComponentsRecursionChildren = this.changedComponentsRecursion(path, parentWrapper, component);
                    if (changedComponentsRecursionChildren != null) {
                        wrapperChildren.addAll(changedComponentsRecursionChildren);
                    }
                }
            }
            if (wrapperChildren == null) {
                wrapperChildren = this.componentsChildrenDive(path, parentWrapper, component);
                continue;
            }
            List<InspectorFolderWrapper> componentsChildren = this.componentsChildrenDive(path, parentWrapper, component);
            if (componentsChildren == null) continue;
            wrapperChildren.addAll(componentsChildren);
        }
        return wrapperChildren;
    }

    private List<InspectorFolderWrapper> componentsRecursion(InspectorFolderPath path, InspectorFolderWrapper parentWrapper, DesignComponent component) {
        InspectorFolderWrapper wrapper;
        ArrayList<InspectorFolderWrapper> wrapperChildren = null;
        for (DesignComponent componentToAdd : this.componentsToAdd) {
            if (componentToAdd.getComponentID() != component.getComponentID()) continue;
            for (InspectorFolderPresenter presenter : componentToAdd.getPresenters(InspectorFolderPresenter.class)) {
                if (presenter == null || !presenter.getFolder().isInside(path, presenter.getFolder(), componentToAdd) || presenter.getFolder().getComponentID() == null || parentWrapper.getChildrenFolders() != null && parentWrapper.getChildrenFolders().contains(presenter.getFolder())) continue;
                if (wrapperChildren == null) {
                    wrapperChildren = new ArrayList<InspectorFolderWrapper>();
                }
                wrapper = new InspectorFolderWrapper(this.document, presenter.getFolder());
                wrapperChildren.add(wrapper);
                this.foldersToUpdate.add(parentWrapper);
                this.foldersToExtend.add(parentWrapper);
            }
        }
        for (DesignComponent componentToUndo : this.componentsToUndo) {
            if (componentToUndo.getComponentID() != component.getComponentID()) continue;
            for (InspectorFolderPresenter presenter : componentToUndo.getPresenters(InspectorFolderPresenter.class)) {
                if (presenter == null || !presenter.getFolder().isInside(path, presenter.getFolder(), componentToUndo) || presenter.getFolder().getComponentID() == null) continue;
                if (wrapperChildren == null) {
                    wrapperChildren = new ArrayList();
                }
                wrapper = new InspectorFolderWrapper(this.document, presenter.getFolder());
                wrapperChildren.add(wrapper);
                this.foldersToUpdate.add(parentWrapper);
                this.foldersToExtend.add(parentWrapper);
                this.deletedComponentsCash.remove(componentToUndo);
            }
        }
        return wrapperChildren;
    }

    private List<InspectorFolderWrapper> changedComponentsRecursion(InspectorFolderPath path, InspectorFolderWrapper parentWrapper, DesignComponent component) {
        ArrayList<InspectorFolderWrapper> wrapperChildren = null;
        for (InspectorFolderPresenter presenter : component.getPresenters(InspectorFolderPresenter.class)) {
            if (presenter == null || !presenter.getFolder().isInside(path, presenter.getFolder(), component)) continue;
            if (presenter.getFolder().getComponentID() != null) {
                if (!parentWrapper.removeChild(presenter.getFolder())) continue;
                if (wrapperChildren == null) {
                    wrapperChildren = new ArrayList<InspectorFolderWrapper>();
                }
                InspectorFolderWrapper wrapper = new InspectorFolderWrapper(this.document, presenter.getFolder());
                wrapperChildren.add(wrapper);
                path.add(wrapper.getFolder());
                this.rebulidDive(path, wrapper);
                path.remove(wrapper.getFolder());
                this.foldersToUpdate.add(parentWrapper);
                continue;
            }
            throw new IllegalArgumentException("Argument ComponentID is null: component: " + component);
        }
        return wrapperChildren;
    }

    private List<InspectorFolderWrapper> registryDescriptorsDive(InspectorFolderPath path, InspectorFolderWrapper parentWrapper) {
        ArrayList<InspectorFolderWrapper> wrapperChildren = null;
        if (this.globalFolders == null) {
            return null;
        }
        for (InspectorFolder folder : this.globalFolders) {
            if (!folder.isInside(path, folder, null) || parentWrapper.getChildrenFolders() != null && parentWrapper.getChildrenFolders().contains(folder)) continue;
            if (wrapperChildren == null) {
                wrapperChildren = new ArrayList<InspectorFolderWrapper>();
            }
            InspectorFolderWrapper wrapper = new InspectorFolderWrapper(this.document, folder);
            wrapperChildren.add(wrapper);
        }
        return wrapperChildren;
    }

    private void rebulidDive(InspectorFolderPath path, InspectorFolderWrapper parentWrapper) {
        List<InspectorFolderWrapper> wrapperChildren = parentWrapper.getFolder() instanceof RootFolder ? this.rebulidComponentsRecursion(path, parentWrapper, this.document.getRootComponent()) : this.rebulidComponentsChildrenDive(path, parentWrapper, this.document.getRootComponent());
        if (wrapperChildren == null) {
            wrapperChildren = this.registryDescriptorsDive(path, parentWrapper);
        } else {
            List<InspectorFolderWrapper> registryChildren = this.registryDescriptorsDive(path, parentWrapper);
            if (registryChildren != null) {
                wrapperChildren.addAll(registryChildren);
            }
        }
        if (wrapperChildren == null) {
            wrapperChildren = parentWrapper.getChildren();
        } else {
            List<InspectorFolderWrapper> parentChildren = parentWrapper.getChildren();
            if (parentChildren != null) {
                wrapperChildren.addAll(parentChildren);
            }
        }
        if (wrapperChildren != null) {
            for (InspectorFolderWrapper folder : wrapperChildren) {
                path.add(folder.getFolder());
                this.rebulidDive(path, folder);
                path.remove(folder.getFolder());
            }
            parentWrapper.setChildren(wrapperChildren);
        }
    }

    private List<InspectorFolderWrapper> rebulidComponentsChildrenDive(InspectorFolderPath path, InspectorFolderWrapper parentWrapper, DesignComponent parentComponent) {
        List<InspectorFolderWrapper> wrapperChildren = null;
        for (DesignComponent component : parentComponent.getComponents()) {
            List<InspectorFolderWrapper> tempWrapperChildren = this.rebulidComponentsRecursion(path, parentWrapper, component);
            if (wrapperChildren == null) {
                wrapperChildren = tempWrapperChildren;
            } else if (tempWrapperChildren != null) {
                wrapperChildren.addAll(tempWrapperChildren);
            }
            if (wrapperChildren == null) {
                wrapperChildren = this.rebulidComponentsChildrenDive(path, parentWrapper, component);
                continue;
            }
            List<InspectorFolderWrapper> componentsChildren = this.rebulidComponentsChildrenDive(path, parentWrapper, component);
            if (componentsChildren == null) continue;
            wrapperChildren.addAll(componentsChildren);
        }
        return wrapperChildren;
    }

    private List<InspectorFolderWrapper> rebulidComponentsRecursion(InspectorFolderPath path, InspectorFolderWrapper parentWrapper, DesignComponent component) {
        ArrayList<InspectorFolderWrapper> childrenWrapper = null;
        for (InspectorFolderPresenter presenter : component.getPresenters(InspectorFolderPresenter.class)) {
            if (presenter == null || !presenter.getFolder().isInside(path, presenter.getFolder(), component) || presenter.getFolder().getComponentID() == null || parentWrapper.getChildrenFolders() != null && parentWrapper.getChildrenFolders().contains(presenter.getFolder())) continue;
            if (childrenWrapper == null) {
                childrenWrapper = new ArrayList<InspectorFolderWrapper>();
            }
            InspectorFolderWrapper wrapper = new InspectorFolderWrapper(this.document, presenter.getFolder());
            childrenWrapper.add(wrapper);
            this.foldersToUpdate.add(parentWrapper);
            this.foldersToExtend.add(parentWrapper);
        }
        return childrenWrapper;
    }

    private void updateChangedDescriptors(Collection<DesignComponent> createdComponents, Collection<DesignComponent> affectedComponents) {
        if (createdComponents != null) {
            for (DesignComponent component : createdComponents) {
                if (component.getPresenters(InspectorFolderPresenter.class).isEmpty()) continue;
                this.componentsToAdd.add(component);
            }
        }
        if (affectedComponents != null) {
            for (DesignComponent component : affectedComponents) {
                if (this.deletedComponentsCash != null && this.deletedComponentsCash.contains(component)) {
                    this.componentsToUndo.add(component);
                }
                if (component == null || component.getParentComponent() != null) continue;
                this.componentsToDelete.add(component);
            }
        }
        InspectorRegistry.getInstance(this.document).remove(this.componentsToAdd);
        InspectorRegistry.getInstance(this.document).remove(this.componentsToDelete);
    }

    private void updateTreeStructureView() {
        this.updateTreeStructureView(this.rootFolderWrapper);
        this.rootFolderWrapper.resolveFolder(this.document);
        this.warmUp((Node)this.rootFolderWrapper.getNode());
    }

    private void updateTreeStructureView(InspectorFolderWrapper parentWrapper) {
        if (parentWrapper.getChildren() != null) {
            for (InspectorFolderWrapper wrapper : parentWrapper.getChildren()) {
                this.updateTreeStructureView(wrapper);
                wrapper.resolveFolder(this.document);
            }
        }
        if (parentWrapper.getChildren() == null || parentWrapper.getChildren().isEmpty()) {
            parentWrapper.resolveFolder(this.document);
        }
    }

    private void warmUp(Node node) {
        for (Node child : node.getChildren().getNodes()) {
            this.warmUp(child);
        }
    }

    private void updateRegistredFolders() {
        if (this.registry == null) {
            return;
        }
        this.registry.readAccess(new Runnable(){

            @Override
            public void run() {
                InspectorWrapperTree.this.globalFolders = InspectorWrapperTree.this.registry.getFolders();
            }
        });
    }

    InspectorFolderWrapper getRootWrapperFolder() {
        return this.rootFolderWrapper;
    }

    @Override
    public void notifyRegistryContentChange() {
        this.updateRegistredFolders();
    }

    Collection<Node> getSelectedNodes() {
        return this.getSelectedNodes(this.rootFolderWrapper);
    }

    private Collection<Node> getSelectedNodes(InspectorFolderWrapper parentFolder) {
        if (parentFolder == null || parentFolder.getChildren() == null) {
            return null;
        }
        HashSet<Node> selectedNodes = new HashSet<Node>();
        if (this.document.getSelectedComponents().isEmpty()) {
            return selectedNodes;
        }
        for (InspectorFolderWrapper folder : parentFolder.getChildren()) {
            if (folder.getChildren() != null) {
                selectedNodes.addAll(this.getSelectedNodes(folder));
            }
            for (DesignComponent component : this.document.getSelectedComponents()) {
                Long componentID = folder.getFolder().getComponentID();
                if (componentID == null || componentID.longValue() != component.getComponentID() || !folder.getFolder().getDisplayName().equals(InfoPresenter.getDisplayName((DesignComponent)component))) continue;
                selectedNodes.add((Node)folder.getNode());
            }
        }
        return selectedNodes;
    }

    private Collection<DesignComponent> markAllComponentsAsToAdd() {
        HashSet<DesignComponent> componentsToAdd = new HashSet<DesignComponent>();
        if (this.document.getRootComponent() != null) {
            this.markAllComponentsAsToAdd(componentsToAdd, this.document.getRootComponent());
        }
        return componentsToAdd;
    }

    private Collection<DesignComponent> markAllComponentsAsToAdd(Collection<DesignComponent> componentsToAdd, DesignComponent parentComponent) {
        componentsToAdd.add(parentComponent);
        for (DesignComponent component : parentComponent.getComponents()) {
            this.markAllComponentsAsToAdd(componentsToAdd, component);
        }
        return componentsToAdd;
    }

    void terminate() {
        if (this.rootFolderWrapper != null) {
            this.terminateChildern(this.rootFolderWrapper);
            this.globalFolders = null;
            this.registry = null;
            this.document = null;
            this.componentsToDelete = null;
            this.componentsToAdd = null;
            this.componentsToUndo = null;
            this.foldersToUpdate = null;
            this.deletedComponentsCash = null;
            this.foldersToExtend = null;
            this.rootFolderWrapper = null;
            this.ui = null;
            this.lock = false;
        }
    }

    private void terminateChildern(InspectorFolderWrapper fw) {
        if (fw.getChildren() != null) {
            for (InspectorFolderWrapper child : fw.getChildren()) {
                this.terminateChildern(child);
            }
        }
        fw.terminate();
    }

    private class RootFolder
    extends InspectorFolder {
        private RootFolder() {
        }

        @Override
        public TypeID getTypeID() {
            return new TypeID(TypeID.Kind.PRIMITIVE, "");
        }

        @Override
        public Long getComponentID() {
            return null;
        }

        @Override
        public Image getIcon() {
            return new Image(){

                @Override
                public void flush() {
                }

                @Override
                public Graphics getGraphics() {
                    return null;
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return 0;
                }

                @Override
                public Object getProperty(String name, ImageObserver observer) {
                    return null;
                }

                @Override
                public ImageProducer getSource() {
                    return null;
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return 0;
                }
            };
        }

        @Override
        public String getDisplayName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }

        @Override
        public Action[] getActions() {
            return null;
        }

        public NewType[] getNewTypes() {
            return null;
        }

        @Override
        public boolean canRename() {
            return false;
        }

        @Override
        public boolean isInside(InspectorFolderPath path, InspectorFolder folder, DesignComponent component) {
            return false;
        }

        @Override
        public String getName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }

        @Override
        public InspectorOrderingController[] getOrderingControllers() {
            return null;
        }

        @Override
        public String getHtmlDisplayName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }
    }
}

