/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;

public class DefaultOrderingController
implements InspectorOrderingController {
    private static final Comparator<InspectorFolder> DEFAULT_STRING_COMPARATOR = new Comparator<InspectorFolder>(){

        @Override
        public int compare(InspectorFolder fd1, InspectorFolder fd2) {
            return fd1.getDisplayName().compareTo(fd2.getDisplayName());
        }
    };
    private Integer order;
    private List<TypeID> types;

    public DefaultOrderingController(Integer order, TypeID ... types) {
        if (types == null) {
            throw new IllegalArgumentException("types argument cant be null");
        }
        this.order = order;
        this.types = Arrays.asList(types);
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent component, Collection<InspectorFolder> folders) {
        ArrayList<InspectorFolder> sortedList = new ArrayList<InspectorFolder>(folders);
        Collections.sort(sortedList, DEFAULT_STRING_COMPARATOR);
        return sortedList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument document, TypeID typeID) {
        return this.types.contains(typeID);
    }
}

