/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.clone;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ClonePanel
extends JPanel
implements ActionListener {
    private File repository;
    private JButton browseButton;
    private JLabel destinationLabel;
    private JLabel fromLabel;
    private JTextField fromTextField;
    private JCheckBox setMainCheckBox;
    private JTextField toCloneField;
    private JLabel toLabel;
    private JLabel toNameLabel;
    final JTextField toTextField = new JTextField();

    public ClonePanel(File repo, File to) {
        this.repository = repo;
        this.initComponents();
        this.browseButton.addActionListener(this);
        this.setMainCheckBox.addActionListener(this);
        this.fromTextField.setText(repo.getAbsolutePath());
        this.toTextField.setText(to.getParent());
        this.toCloneField.setText(to.getName());
        this.setMainCheckBox.setSelected(HgModuleConfig.getDefault().getSetMainProject());
    }

    public File getTargetDir() {
        return new File(this.toTextField.getText(), this.toCloneField.getText());
    }

    private void initComponents() {
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        this.browseButton = new JButton();
        this.fromTextField = new JTextField();
        this.toNameLabel = new JLabel();
        this.toCloneField = new JTextField();
        this.destinationLabel = new JLabel();
        this.setMainCheckBox = new JCheckBox();
        this.fromLabel.setLabelFor(this.fromTextField);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.fromLabel.text"));
        this.toLabel.setLabelFor(this.toTextField);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.browseButton.text"));
        this.fromTextField.setEditable(false);
        this.toNameLabel.setLabelFor(this.toCloneField);
        Mnemonics.setLocalizedText((JLabel)this.toNameLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toName.text"));
        Mnemonics.setLocalizedText((JLabel)this.destinationLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"destinationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.setMainCheckBox, (String)NbBundle.getMessage(ClonePanel.class, (String)"openCheckbox.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.destinationLabel).add((Component)this.fromLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.toNameLabel).add((Component)this.setMainCheckBox))).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.toLabel))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fromTextField, -1, 258, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.toCloneField, -1, 165, Short.MAX_VALUE).add((Component)this.toTextField, -1, 165, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fromLabel).add((Component)this.fromTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.destinationLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.toTextField, -2, -1, -2).add((Component)this.toLabel)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.toCloneField, -2, -1, -2).add((Component)this.toNameLabel)).addPreferredGap(0).add((Component)this.setMainCheckBox, -2, 21, -2).addContainerGap()));
        this.toTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_Browse"));
        this.fromTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_fromTextField"));
        this.toCloneField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toCloneField"));
        this.setMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_setMainCheckBox"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.setMainCheckBox) {
            HgModuleConfig.getDefault().setSetMainProject(this.setMainCheckBox.isSelected());
        }
    }

    private void onBrowseClick() {
        File oldFile = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(ClonePanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ClonePanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(ClonePanel.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.toTextField.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        File defaultDir = null;
        String current = this.toTextField.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }
}

