/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class MercurialVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener {
    private Set<File> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static final Integer priority = Utils.getPriority((String)"mercurial");
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File a, File b) {
            File fra = MercurialVCS.this.getTopmostManagedAncestor(a);
            File frb = MercurialVCS.this.getTopmostManagedAncestor(b);
            return fra != null && fra.equals(frb);
        }

        public File findRoot(File file) {
            return MercurialVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public MercurialVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_MainMenu"));
        this.putProperty(PROP_PRIORITY, priority);
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public File getTopmostManagedAncestor(File file) {
        long t = System.currentTimeMillis();
        Mercurial.LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            Mercurial.LOG.fine(" cached as unversioned");
            return null;
        }
        Mercurial.LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        File parent = this.getKnownParent(file);
        if (parent != null) {
            Mercurial.LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent " + parent);
            return parent;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (HgUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> done = new HashSet<File>();
        File topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                Mercurial.LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            if (HgUtils.hgExistsFor(file)) {
                Mercurial.LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                done.clear();
                topmost = file;
            } else {
                Mercurial.LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            Mercurial.LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            Mercurial.LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (topmost != null) {
            this.knownRoots.add(topmost);
        }
        return topmost;
    }

    private File getKnownParent(File file) {
        File[] roots = this.knownRoots.toArray(new File[this.knownRoots.size()]);
        File knownParent = null;
        for (File r : roots) {
            if (!Utils.isAncestorOrEqual((File)r, (File)file) || knownParent != null && !Utils.isAncestorOrEqual((File)knownParent, (File)r)) continue;
            knownParent = r;
        }
        return knownParent;
    }

    public VCSAnnotator getVCSAnnotator() {
        return Mercurial.getInstance().getMercurialAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Mercurial.getInstance().getMercurialInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        Mercurial.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (event.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)event.getNewValue());
        } else if (event.getPropertyName().equals("versionedFilesChanged")) {
            Mercurial.LOG.fine("cleaning unversioned parents cache");
            this.unversionedParents.clear();
            this.fireVersionedFilesChanged();
        } else if (event.getPropertyName().equals("event.badgeChanged")) {
            this.fireStatusChanged((Set)event.getNewValue());
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }
}

