/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

public class RemoteProcReader
extends ProcReaderImpl {
    private static final Logger log = DLightLogger.getLogger(RemoteProcReader.class);
    private final String usageFile;
    private final String lwpsUsageCmd;
    private final String statusFile;
    private final String lwpDir;
    private final NativeProcessBuilder npb;

    public RemoteProcReader(ExecutionEnvironment execEnv, int pid, ByteOrder byteOrder, DataModel dataModel) {
        super(byteOrder, dataModel);
        this.usageFile = "/proc/" + pid + "/usage";
        this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
        this.npb.setExecutable("cat");
        this.statusFile = "/proc/" + pid + "/status";
        this.lwpDir = "/proc/" + pid + "/lwp";
        this.lwpsUsageCmd = "cat " + this.lwpDir + "/*/lwpusage";
    }

    @Override
    public PStatus getProcessStatus() {
        PStatus result = null;
        try {
            NativeProcess p = this.npb.setArguments(new String[]{this.statusFile}).call();
            result = this.getProcessStatus(p.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public PUsage getProcessUsage() throws IOException {
        NativeProcess p = this.npb.setArguments(new String[]{this.usageFile}).call();
        return this.getProcessUsage(p.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LWPUsage> getThreadsInfo() {
        ArrayList<LWPUsage> result = new ArrayList<LWPUsage>();
        try {
            NativeProcess p = this.npb.setCommandLine(this.lwpsUsageCmd).call();
            int exitCode = -1;
            try {
                exitCode = p.waitFor();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (exitCode != 0) {
                Object es;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("cannot exec " + this.lwpsUsageCmd);
                    es = p.getErrorStream();
                    if (((InputStream)es).available() > 0) {
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)es));
                        while (br.ready()) {
                            log.fine("\t" + br.readLine());
                        }
                    }
                }
                es = result;
                return es;
            }
            InputStream is = p.getInputStream();
            MultyFilesStream ss = new MultyFilesStream(is, 256);
            try {
                while (ss.available() > 0) {
                    result.add(this.getProcessUsage(ss));
                }
                return result;
            }
            catch (IOException ex) {
                return result;
            }
            finally {
                ss.doClose();
            }
        }
        catch (IOException iOException) {
            return result;
        }
        finally {
            this.npb.setCommandLine(null);
        }
    }

    private static class MultyFilesStream
    extends FilterInputStream {
        private final int chunkSize;

        private MultyFilesStream(InputStream stream, int chunkSize) {
            super(stream);
            this.chunkSize = chunkSize;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return super.read(b, off, Math.min(len, this.chunkSize));
        }

        @Override
        public void close() throws IOException {
        }

        public void doClose() throws IOException {
            super.close();
        }
    }
}

