/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.highlight.error.BrokenProjectService;
import org.openide.util.NbBundle;

public class BadgeProvider {
    private static BadgeProvider myInstance = new BadgeProvider();
    private Storage storage = new Storage();
    private final Object listLock = new Object();

    private BadgeProvider() {
    }

    public static BadgeProvider getInstance() {
        return myInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateProject(CsmProject project) {
        boolean badgeStateChanged = false;
        Object object = this.listLock;
        synchronized (object) {
            boolean oldState = this.storage.contains(project);
            CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
            block3: for (CsmFile file : project.getAllFiles()) {
                if (!file.getErrors().isEmpty()) {
                    if (this.storage.contains(file)) continue;
                    this.storage.add(file);
                    badgeStateChanged = true;
                    continue;
                }
                for (CsmInclude incl : fiq.getBrokenIncludes(file)) {
                    if (incl.getIncludeFile() != null) continue;
                    if (this.storage.contains(file)) continue block3;
                    this.storage.add(file);
                    badgeStateChanged = true;
                    continue block3;
                }
                if (!this.storage.contains(file)) continue;
                this.storage.remove(file);
                badgeStateChanged = true;
            }
            boolean newState = this.storage.contains(project);
            if (oldState == newState) {
                badgeStateChanged = false;
            }
        }
        if (badgeStateChanged) {
            this.fireBadgeChanged(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFile(CsmFile file) {
        boolean badgeStateChanged = false;
        CsmProject project = file.getProject();
        Object object = this.listLock;
        synchronized (object) {
            boolean newState;
            boolean oldState = this.storage.contains(project);
            boolean badFile = false;
            if (CsmFileInfoQuery.getDefault().hasBrokenIncludes(file) || !file.getErrors().isEmpty()) {
                badFile = true;
                if (!this.storage.contains(file)) {
                    this.storage.add(file);
                    badgeStateChanged = true;
                }
            }
            if (!badFile && this.storage.contains(file)) {
                this.storage.remove(file);
                badgeStateChanged = true;
            }
            if (oldState == (newState = this.storage.contains(project))) {
                badgeStateChanged = false;
            }
        }
        if (badgeStateChanged) {
            this.fireBadgeChanged(project);
        }
    }

    private void fireBadgeChanged(CsmFile file) {
        BrokenProjectService.fireChanges(null);
    }

    private void fireBadgeChanged(CsmProject csmProject) {
        BrokenProjectService.fireChanges(null);
    }

    private void fireBadgeChanged() {
        BrokenProjectService.fireChanges(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileRemoved(CsmFile file) {
        boolean badgeStateChanged = false;
        CsmProject project = file.getProject();
        Object object = this.listLock;
        synchronized (object) {
            boolean newState;
            boolean oldState = this.storage.contains(project);
            if (this.storage.contains(file)) {
                this.storage.remove(file);
                badgeStateChanged = true;
            }
            if (oldState == (newState = this.storage.contains(project))) {
                badgeStateChanged = false;
            }
        }
        if (badgeStateChanged) {
            this.fireBadgeChanged(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProjects() {
        boolean badgeStateChanged = false;
        Object object = this.listLock;
        synchronized (object) {
            badgeStateChanged = !this.storage.isEmpty();
            this.storage.clear();
        }
        if (badgeStateChanged) {
            this.fireBadgeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(CsmProject project) {
        boolean badgeStateChanged = false;
        Object object = this.listLock;
        synchronized (object) {
            badgeStateChanged = this.storage.contains(project);
            this.storage.remove(project);
        }
        if (badgeStateChanged) {
            this.fireBadgeChanged(project);
        }
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(BadgeProvider.class, (String)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBroken(NativeProject project) {
        Object object = this.listLock;
        synchronized (object) {
            return this.storage.contains(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getFailedFiles(NativeProject nativeProject) {
        Object object = this.listLock;
        synchronized (object) {
            return new HashSet<CsmUID<CsmFile>>(this.storage.getFiles(nativeProject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getFailedFiles(CsmProject csmProject) {
        Object object = this.listLock;
        synchronized (object) {
            return new HashSet<CsmUID<CsmFile>>(this.storage.getFiles(csmProject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFailedFiles(NativeProject nativeProject) {
        Object object = this.listLock;
        synchronized (object) {
            return this.storage.contains(nativeProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFailedFiles(CsmProject csmProject) {
        Object object = this.listLock;
        synchronized (object) {
            return this.storage.contains(csmProject);
        }
    }

    private static class Storage {
        private Map<CsmProject, Set<CsmUID<CsmFile>>> wrongFiles = new HashMap<CsmProject, Set<CsmUID<CsmFile>>>();
        private Map<CsmProject, NativeProject> nativeProjects = new HashMap<CsmProject, NativeProject>();

        private Storage() {
        }

        public Set<CsmUID<CsmFile>> getFiles(CsmProject project) {
            return this.wrongFiles.get(project);
        }

        public Set<CsmUID<CsmFile>> getFiles(NativeProject project) {
            for (Map.Entry<CsmProject, NativeProject> entry : this.nativeProjects.entrySet()) {
                if (project != entry.getValue()) continue;
                return this.getFiles(entry.getKey());
            }
            return Collections.emptySet();
        }

        public boolean isEmpty() {
            return this.nativeProjects.isEmpty();
        }

        public void clear() {
            this.wrongFiles.clear();
            this.nativeProjects.clear();
        }

        public void remove(CsmProject project) {
            this.wrongFiles.remove(project);
            this.nativeProjects.remove(project);
        }

        public void remove(CsmFile file) {
            Set<CsmUID<CsmFile>> set;
            CsmProject project = file.getProject();
            if (project != null && (set = this.getFiles(project)) != null && set.size() > 0) {
                set.remove(UIDs.get((Object)file));
            }
        }

        public void add(CsmFile file) {
            CsmProject project = file.getProject();
            if (project != null) {
                Set<CsmUID<CsmFile>> set = this.getFiles(project);
                if (set == null) {
                    Object id = project.getPlatformProject();
                    if (id instanceof NativeProject) {
                        this.nativeProjects.put(project, (NativeProject)id);
                    }
                    set = new HashSet<CsmUID<CsmFile>>();
                    this.wrongFiles.put(project, set);
                }
                if (set != null) {
                    set.add((CsmUID<CsmFile>)UIDs.get((Object)file));
                }
            }
        }

        public boolean contains(CsmProject project) {
            Set<CsmUID<CsmFile>> set = this.getFiles(project);
            return set != null && set.size() > 0;
        }

        public boolean contains(NativeProject project) {
            Set<CsmUID<CsmFile>> set = this.getFiles(project);
            return set != null && set.size() > 0;
        }

        public boolean contains(CsmFile file) {
            Set<CsmUID<CsmFile>> set;
            CsmProject project = file.getProject();
            if (project != null && (set = this.getFiles(project)) != null) {
                return set.contains(UIDs.get((Object)file));
            }
            return false;
        }
    }
}

