/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class ExtConnection
extends AbstractConnection {
    private final String command;
    private Process process;

    public ExtConnection(String command) {
        this.command = command;
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        try {
            this.process = Runtime.getRuntime().exec(this.command);
            this.setInputStream(new LoggedDataInputStream(new BufferedInputStream(this.process.getInputStream())));
            this.setOutputStream(new LoggedDataOutputStream(new BufferedOutputStream(this.process.getOutputStream())));
        }
        catch (IOException e) {
            throw new AuthenticationException(e, "Failed to execute: " + this.command);
        }
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
            this.verifyProtocol();
            this.process.destroy();
        }
        catch (Exception e) {
            throw new AuthenticationException(e, "Failed to execute: " + this.command);
        }
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.process.destroy();
        }
    }

    public boolean isOpen() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getPort() {
        return 0;
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }
}

