/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.railsprojects.ui.TreeRootNode;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.LibrariesNode;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ProjectRootNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        RailsProject project = (RailsProject)((Object)p.getLookup().lookup(RailsProject.class));
        assert (project != null);
        return new RootChildren(project);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String nodeName) {
            this(project, nodeName, null);
        }

        public PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(ProjectRootNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)((Object)this.project.getLookup().lookup(CustomizerProviderImpl.class));
            if (cp != null) {
                cp.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class FolderViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        Action[] actions;

        public FolderViewFilterNode(SourceGroup sourceGroup, Generator generator, Project project) {
            super((Node)new RootNode(sourceGroup, generator));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    this.actions = new Action[superActions.length + 2];
                    System.arraycopy(superActions, 0, this.actions, 0, superActions.length);
                    this.actions[superActions.length] = null;
                    this.actions[superActions.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(context);
        }
    }

    private static final class RootNode
    extends FilterNode {
        private SourceGroup sourceGroup;

        private RootNode(SourceGroup group, Generator generator) {
            super(RootNode.getOriginalNode(group, generator));
            this.sourceGroup = group;
        }

        private static Node getOriginalNode(SourceGroup group, Generator generator) {
            FileObject root = group.getRootFolder();
            if (root == null || !root.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF, Lookups.singleton((Object)Generator.NONE));
            }
            return new TreeRootNode(group, generator);
        }
    }

    private static class RootChildNode {
        private final SourceGroup group;
        private final FileObject fileObject;
        private final Generator generator;
        private final boolean libraryNode;

        private RootChildNode(SourceGroup group, FileObject fileObject, Generator generator, boolean libraryNode) {
            this.group = group;
            this.fileObject = fileObject;
            this.generator = generator;
            this.libraryNode = libraryNode;
        }

        private RootChildNode(SourceGroup group, FileObject fileObject, Generator generator) {
            this(group, fileObject, generator, false);
        }

        static RootChildNode group(SourceGroup group, Generator generator) {
            return new RootChildNode(group, group.getRootFolder(), generator);
        }

        static RootChildNode fileObject(FileObject fileObject) {
            return new RootChildNode(null, fileObject, Generator.NONE);
        }

        static RootChildNode libraries() {
            return new RootChildNode(null, null, Generator.NONE, true);
        }

        public int hashCode() {
            if (this.libraryNode) {
                return 0;
            }
            return this.fileObject.hashCode();
        }

        public boolean equals(Object obj) {
            String otherDisplayName;
            if (!(obj instanceof RootChildNode)) {
                return false;
            }
            RootChildNode otherKey = (RootChildNode)obj;
            if (this.libraryNode || otherKey.libraryNode) {
                return this.libraryNode && otherKey.libraryNode;
            }
            String thisDisplayName = this.group == null ? null : this.group.getDisplayName();
            String string = otherDisplayName = otherKey.group == null ? null : otherKey.group.getDisplayName();
            return this.fileObject.equals(otherKey.fileObject) && (thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName));
        }

        public String toString() {
            return "ProjectRootNodeFactory[fileObject: " + this.fileObject + ", group: " + this.group + ", generator: " + this.generator + ", libraryNode: " + this.libraryNode + ']';
        }
    }

    private static class RootChildren
    implements NodeList<RootChildNode>,
    ChangeListener {
        private final RailsProject project;
        private final List<ChangeListener> listeners;

        public RootChildren(RailsProject project) {
            this.project = project;
            this.listeners = new ArrayList<ChangeListener>();
        }

        public List<RootChildNode> keys() {
            FileObject[] extra;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] groups = sources.getSourceGroups("ruby");
            ArrayList<RootChildNode> result = new ArrayList<RootChildNode>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                result.add(RootChildNode.group(groups[i], this.getGenerator(groups[i].getName())));
            }
            result.add(RootChildNode.libraries());
            SourceRoots roots = this.project.getSourceRoots();
            if (roots != null && (extra = roots.getExtraFiles()) != null && extra.length > 0) {
                for (FileObject f : extra) {
                    result.add(RootChildNode.fileObject(f));
                }
            }
            return result;
        }

        private Generator getGenerator(String subdir) {
            if (subdir.equals("app/controllers")) {
                return Generator.CONTROLLER;
            }
            if (subdir.equals("app/views")) {
                return Generator.CONTROLLER;
            }
            if (subdir.equals("app/models")) {
                return Generator.MODEL;
            }
            if (subdir.equals("app/metal")) {
                return Generator.METAL;
            }
            if (subdir.equals("db")) {
                return Generator.MIGRATION;
            }
            return Generator.NONE;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
            RootChildren rootChildren = this;
            synchronized (rootChildren) {
                list.addAll(this.listeners);
            }
            for (ChangeListener elem : list) {
                elem.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(RootChildNode key) {
            if (key.libraryNode) {
                return new LibrariesNode((RubyBaseProject)this.project);
            }
            if (key.group != null) {
                return new FolderViewFilterNode(key.group, key.generator, (Project)this.project);
            }
            if (key.fileObject != null) {
                try {
                    if (RakeSupport.isRakeFile((FileObject)key.fileObject)) {
                        return new RakeSupport.RakeNode(key.fileObject);
                    }
                    DataObject dobj = DataObject.find((FileObject)key.fileObject);
                    return new FilterNode(dobj.getNodeDelegate());
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            throw new AssertionError((Object)("Unknown/Invalid key: " + key));
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootChildren.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

