/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.StopManager;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class StopAction
extends CookieAction {
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public StopAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_StopAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StopAction.class);
    }

    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        DatabaseServer server = (DatabaseServer)activatedNodes[0].getCookie(DatabaseServer.class);
        return server != null && !StopManager.getDefault().isStopRequested();
    }

    protected void performAction(Node[] activatedNodes) {
        DatabaseServer server = (DatabaseServer)activatedNodes[0].getCookie(DatabaseServer.class);
        String path = server.getStopPath();
        String message = Utils.getMessage("MSG_NoStopPath", new Object[0]);
        PropertiesDialog dialog = new PropertiesDialog(server);
        while (path == null || path.equals("")) {
            if (!Utils.displayConfirmDialog(message)) {
                return;
            }
            if (!dialog.displayDialog(PropertiesDialog.Tab.ADMIN)) {
                return;
            }
            path = server.getStopPath();
        }
        StopManager.getDefault().stop(server);
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }
}

