/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.metadata;

import java.sql.Connection;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbMetaDataListener;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.MetadataModels;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.util.Mutex;

public class MetadataModelManager {
    private static final Logger LOGGER = Logger.getLogger(MetadataModelManager.class.getName());
    private static final WeakHashMap<DatabaseConnection, MetadataModel> conn2Model = new WeakHashMap();

    private MetadataModelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataModel get(DatabaseConnection dbconn) {
        Class<MetadataModelManager> clazz = MetadataModelManager.class;
        synchronized (MetadataModelManager.class) {
            Connection conn = MetadataModelManager.checkAndGetConnection(dbconn);
            MetadataModel model = conn2Model.get(dbconn);
            if (model == null) {
                model = MetadataModels.createModel((Connection)conn, (String)dbconn.getSchema());
                conn2Model.put(dbconn, model);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return model;
        }
    }

    private static Connection checkAndGetConnection(final DatabaseConnection dbconn) {
        Connection conn = dbconn.getJDBCConnection();
        if (conn == null) {
            conn = (Connection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Connection>(){

                public Connection run() {
                    ConnectionManager.getDefault().showConnectionDialog(dbconn);
                    return dbconn.getJDBCConnection();
                }
            });
        }
        return conn;
    }

    private static final class Listener
    implements DbMetaDataListener {
        private static Listener create() {
            return new Listener();
        }

        private Listener() {
        }

        @Override
        public void tablesChanged(DatabaseConnection dbconn) {
            Connection conn = MetadataModelManager.checkAndGetConnection(dbconn);
            if (conn == null) {
                return;
            }
            try {
                MetadataModelManager.get(dbconn).runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata md) {
                        md.refresh();
                    }
                });
            }
            catch (MetadataModelException mde) {
                LOGGER.log(Level.INFO, mde.getMessage(), mde);
            }
        }

        @Override
        public void tableChanged(DatabaseConnection dbconn, final String tableName) {
            Connection conn = MetadataModelManager.checkAndGetConnection(dbconn);
            if (conn == null) {
                return;
            }
            try {
                MetadataModelManager.get(dbconn).runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata md) {
                        Table table = md.getDefaultSchema().getTable(tableName);
                        if (table != null) {
                            md.getDefaultSchema().getTable(tableName).refresh();
                        } else {
                            LOGGER.log(Level.INFO, "Table '" + tableName + "' that was just changed no longer exists");
                        }
                    }
                });
            }
            catch (MetadataModelException mde) {
                LOGGER.log(Level.INFO, mde.getMessage(), mde);
            }
        }
    }
}

