/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.sql.support;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class SQLIdentifiers {
    private SQLIdentifiers() {
    }

    public static Quoter createQuoter(DatabaseMetaData dbmd) {
        return new DatabaseMetaDataQuoter(dbmd);
    }

    private static class DatabaseMetaDataQuoter
    extends Quoter {
        private static final Logger LOGGER = Logger.getLogger(DatabaseMetaDataQuoter.class.getName());
        private static final int LC_RULE = 0;
        private static final int UC_RULE = 1;
        private static final int MC_RULE = 2;
        private final String extraNameChars;
        private final int caseRule;

        private DatabaseMetaDataQuoter(DatabaseMetaData dbmd) {
            super(DatabaseMetaDataQuoter.getQuoteString(dbmd));
            this.extraNameChars = DatabaseMetaDataQuoter.getExtraNameChars(dbmd);
            this.caseRule = DatabaseMetaDataQuoter.getCaseRule(dbmd);
        }

        @Override
        public final String quoteIfNeeded(String identifier) {
            Parameters.notNull((CharSequence)"identifier", (Object)identifier);
            if (this.needToQuote(identifier)) {
                return this.doQuote(identifier);
            }
            return identifier;
        }

        @Override
        public final String quoteAlways(String identifier) {
            Parameters.notNull((CharSequence)"identifier", (Object)identifier);
            if (!this.alreadyQuoted(identifier)) {
                return this.doQuote(identifier);
            }
            return identifier;
        }

        private boolean needToQuote(String identifier) {
            assert (identifier != null);
            if (this.alreadyQuoted(identifier)) {
                return false;
            }
            int length = identifier.length();
            for (int i = 0; i < length; ++i) {
                if (!this.charNeedsQuoting(identifier.charAt(i), i == 0)) continue;
                return true;
            }
            if (this.caseRule == 1 && DatabaseMetaDataQuoter.containsLowerCase(identifier)) {
                return true;
            }
            if (this.caseRule == 0 && DatabaseMetaDataQuoter.containsUpperCase(identifier)) {
                return true;
            }
            try {
                ClassLoader systemLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> cl = Class.forName("org.netbeans.modules.db.api.sql.SQLKeywords", false, systemLoader);
                Method m = cl.getDeclaredMethod("isSQL99Keyword", String.class);
                if (((Boolean)m.invoke(null, identifier)).booleanValue()) {
                    return true;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "SQLKeywords class cannot be used.", ex);
            }
            return false;
        }

        private boolean charNeedsQuoting(char ch, boolean isFirstChar) {
            if (DatabaseMetaDataQuoter.isUpperCase(ch) || DatabaseMetaDataQuoter.isLowerCase(ch)) {
                return false;
            }
            if (DatabaseMetaDataQuoter.isNumber(ch) || ch == '_') {
                return isFirstChar;
            }
            return this.extraNameChars.indexOf(ch) == -1;
        }

        private static boolean isUpperCase(char ch) {
            return ch >= 'A' && ch <= 'Z';
        }

        private static boolean isLowerCase(char ch) {
            return ch >= 'a' && ch <= 'z';
        }

        private static boolean isNumber(char ch) {
            return ch >= '0' && ch <= '9';
        }

        private static boolean containsLowerCase(String identifier) {
            int length = identifier.length();
            for (int i = 0; i < length; ++i) {
                if (!DatabaseMetaDataQuoter.isLowerCase(identifier.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static boolean containsUpperCase(String identifier) {
            int length = identifier.length();
            for (int i = 0; i < length; ++i) {
                if (!DatabaseMetaDataQuoter.isUpperCase(identifier.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static String getExtraNameChars(DatabaseMetaData dbmd) {
            String chars = "";
            try {
                chars = dbmd.getExtraNameCharacters();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getExtraNameCharacters() failed (" + e.getMessage() + "). " + "Using standard set of characters");
                LOGGER.log(Level.FINE, null, e);
            }
            return chars;
        }

        private static String getQuoteString(DatabaseMetaData dbmd) {
            String quoteStr = "\"";
            try {
                quoteStr = dbmd.getIdentifierQuoteString().trim();
                if (quoteStr.length() == 0) {
                    quoteStr = "\"";
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getIdentifierQuoteString() failed (" + e.getMessage() + "). " + "Using '\"' for quoting SQL identifiers");
                LOGGER.log(Level.FINE, null, e);
            }
            return quoteStr;
        }

        private static int getCaseRule(DatabaseMetaData dbmd) {
            int rule = 1;
            try {
                rule = dbmd.storesUpperCaseIdentifiers() ? 1 : (dbmd.storesLowerCaseIdentifiers() ? 0 : (dbmd.storesMixedCaseIdentifiers() ? 2 : 1));
            }
            catch (SQLException sqle) {
                LOGGER.log(Level.WARNING, "Exception trying to find out how the database stores unquoted identifiers, assuming upper case: " + sqle.getMessage());
                LOGGER.log(Level.FINE, null, sqle);
            }
            return rule;
        }
    }

    public static abstract class Quoter {
        final String quoteString;

        Quoter(String quoteString) {
            this.quoteString = quoteString;
        }

        public abstract String quoteIfNeeded(String var1);

        public abstract String quoteAlways(String var1);

        public String unquote(String identifier) {
            Parameters.notNull((CharSequence)"identifier", (Object)identifier);
            int start = 0;
            while (identifier.regionMatches(start, this.quoteString, 0, this.quoteString.length())) {
                start += this.quoteString.length();
            }
            int end = identifier.length();
            if (end > start) {
                int offset;
                while (identifier.regionMatches(offset = end - this.quoteString.length(), this.quoteString, 0, this.quoteString.length())) {
                    end = offset;
                }
            }
            String result = "";
            if (start < end) {
                result = identifier.substring(start, end);
            }
            return result;
        }

        public String getQuoteString() {
            return this.quoteString;
        }

        boolean alreadyQuoted(String identifier) {
            return identifier.startsWith(this.quoteString) && identifier.endsWith(this.quoteString);
        }

        String doQuote(String identifier) {
            return this.quoteString + identifier + this.quoteString;
        }
    }
}

