/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataEditorViewFactory;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.openide.util.Lookup;

public class EditorViewFactorySupport {
    private static final Lookup.Result factoriesLookupResult = Lookup.getDefault().lookupResult(DataEditorViewFactory.class);

    public static Collection<DataEditorView> createEditorViews(DataObjectContext context) {
        String projectType = IOSupport.resolveProjectType(context);
        if (projectType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataEditorView> list = new ArrayList<DataEditorView>();
        for (Object factory : factoriesLookupResult.allInstances()) {
            DataEditorView desc = ((DataEditorViewFactory)factory).createEditorView(context);
            if (desc == null) continue;
            list.add(desc);
        }
        Collections.sort(list, new Comparator<DataEditorView>(){

            @Override
            public int compare(DataEditorView o1, DataEditorView o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return Collections.unmodifiableCollection(list);
    }
}

