/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class GrailsCommandChooser
extends JPanel {
    private static final Object NO_TASK_ITEM = GrailsCommandChooser.getMessage("GrailsCommandChooser.no.matching.task", new String[0]);
    private static boolean debug;
    private static String lastTask;
    private static Map<String, Map<GrailsCommand, ParameterContainer>> prjToTask;
    private final GrailsProject project;
    private final List<GrailsCommand> allTasks = new ArrayList<GrailsCommand>();
    private JButton runButton;
    private boolean refreshNeeded;
    private JCheckBox debugCheckbox;
    private JLabel matchingTaskLabel;
    private JList matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JTextField rakeTaskField;
    private JPanel rakeTaskFieldPanel;
    private JLabel rakeTaskHint;
    private JLabel rakeTaskLabel;
    private JLabel taskParamLabel;
    private JComboBox taskParametersComboBox;

    public static CommandDescriptor select(GrailsProject grailsProject) {
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        final JButton jButton = new JButton(GrailsCommandChooser.getMessage("GrailsCommandChooser.runButton", new String[0]));
        final GrailsCommandChooser grailsCommandChooser = new GrailsCommandChooser(grailsProject, jButton);
        String string = GrailsCommandChooser.getMessage("GrailsCommandChooser.title", ProjectUtils.getInformation((Project)grailsProject).getDisplayName());
        jButton.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.runButton.accessibleDescription", new String[0]));
        GrailsCommandChooser.setRunButtonState(jButton, grailsCommandChooser);
        grailsCommandChooser.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GrailsCommandChooser.setRunButtonState(jButton, grailsCommandChooser);
                grailsCommandChooser.initTaskParameters();
            }
        });
        final JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)GrailsCommandChooser.getMessage("GrailsCommandChooser.refreshButton", new String[0]));
        jButton2.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.refreshButton.accessibleDescription", new String[0]));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                jButton.setEnabled(false);
                grailsCommandChooser.reloadTasks(new Runnable(){

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        jButton2.setEnabled(true);
                        GrailsCommandChooser.setRunButtonState(jButton, grailsCommandChooser);
                    }
                });
            }
        });
        Object[] objectArray = new Object[]{jButton2, jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grailsCommandChooser, string, true, objectArray, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{jButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(GrailsCommandChooser.getMessage("GrailsCommandChooser.accessibleName", new String[0]));
        dialog.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.accessibleDescription", new String[0]));
        if (grailsCommandChooser.refreshNeeded) {
            jButton2.setEnabled(false);
            jButton.setEnabled(false);
            grailsCommandChooser.reloadTasks(new Runnable(){

                @Override
                public void run() {
                    assert (EventQueue.isDispatchThread()) : "is EDT";
                    jButton2.setEnabled(true);
                    GrailsCommandChooser.setRunButtonState(jButton, grailsCommandChooser);
                }
            });
        }
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            GrailsCommand grailsCommand = grailsCommandChooser.getSelectedTask();
            debug = grailsCommandChooser.debugCheckbox.isSelected();
            lastTask = grailsCommand.getCommand();
            grailsCommandChooser.storeParameters();
            return new CommandDescriptor(grailsCommand, grailsCommandChooser.getParameters(), debug);
        }
        return null;
    }

    private void initTaskParameters() {
        GrailsCommand grailsCommand = this.getSelectedTask();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(this.getStoredParams(grailsCommand));
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.preselectLastSelectedParam(grailsCommand);
    }

    private void preselectLastSelectedParam(GrailsCommand grailsCommand) {
        ParameterContainer parameterContainer = this.getTasksToParams().get(grailsCommand);
        if (parameterContainer == null) {
            return;
        }
        String string = parameterContainer.getLastSelected();
        if (string == null) {
            this.taskParametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.taskParametersComboBox.getItemCount(); ++i) {
            Object e = this.taskParametersComboBox.getItemAt(i);
            if (!e.equals(string)) continue;
            this.taskParametersComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Map<GrailsCommand, ParameterContainer> getTasksToParams() {
        String string = this.project.getProjectDirectory().getPath();
        Map<GrailsCommand, ParameterContainer> map = prjToTask.get(string);
        if (map == null) {
            map = new HashMap<GrailsCommand, ParameterContainer>();
            prjToTask.put(string, map);
        }
        return map;
    }

    private List<String> getStoredParams(GrailsCommand grailsCommand) {
        if (grailsCommand == null) {
            return Collections.emptyList();
        }
        Map<GrailsCommand, ParameterContainer> map = this.getTasksToParams();
        if (map == null) {
            return Collections.emptyList();
        }
        ParameterContainer parameterContainer = map.get(grailsCommand);
        if (parameterContainer == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(parameterContainer.getParams());
        Collections.sort(arrayList);
        return arrayList;
    }

    private String getParameters() {
        Object object = this.taskParametersComboBox.getSelectedItem();
        return object.toString().trim();
    }

    private static void setRunButtonState(JButton jButton, GrailsCommandChooser grailsCommandChooser) {
        jButton.setEnabled(grailsCommandChooser.getSelectedTask() != null);
    }

    private GrailsCommandChooser(GrailsProject grailsProject, JButton jButton) {
        this.runButton = jButton;
        this.project = grailsProject;
        this.initComponents();
        this.matchingTaskList.setCellRenderer(new GrailsCommandRenderer());
        this.debugCheckbox.setSelected(debug);
        this.refreshNeeded = this.reloadAllTasks();
        this.refreshTaskList();
        this.rakeTaskField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GrailsCommandChooser.this.refreshTaskList();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GrailsCommandChooser.this.refreshTaskList();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GrailsCommandChooser.this.refreshTaskList();
            }
        });
        this.preselectLastlySelected();
        this.initTaskParameters();
    }

    private void storeParameters() {
        ParameterContainer parameterContainer;
        String string = this.project.getProjectDirectory().getPath();
        Map<GrailsCommand, ParameterContainer> map = prjToTask.get(string);
        if (map == null) {
            map = new HashMap<GrailsCommand, ParameterContainer>();
            prjToTask.put(string, map);
        }
        if ((parameterContainer = map.get(this.getSelectedTask())) == null) {
            parameterContainer = new ParameterContainer();
            map.put(this.getSelectedTask(), parameterContainer);
        }
        String string2 = this.getParameters();
        parameterContainer.addParam(string2);
        parameterContainer.setLastSelected(string2);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (GrailsCommand grailsCommand : this.allTasks) {
            if (!lastTask.equals(grailsCommand.getCommand())) continue;
            this.matchingTaskList.setSelectedValue(grailsCommand, true);
            break;
        }
        this.initTaskParameters();
    }

    private boolean reloadAllTasks() {
        this.allTasks.clear();
        List<GrailsCommand> list = this.project.getCommandSupport().getGrailsCommands();
        if (list != null) {
            this.allTasks.addAll(list);
            return false;
        }
        return true;
    }

    private void refreshTaskList() {
        String string = this.rakeTaskField.getText().trim();
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        List<GrailsCommand> list = Filter.getFilteredTasks(this.allTasks, string);
        for (GrailsCommand grailsCommand : list) {
            defaultListModel.addElement(grailsCommand);
        }
        this.matchingTaskList.setModel(defaultListModel);
        if (defaultListModel.isEmpty()) {
            defaultListModel.addElement(NO_TASK_ITEM);
        }
        this.matchingTaskList.setSelectedIndex(0);
        this.initTaskParameters();
    }

    private void reloadTasks(final Runnable runnable) {
        final Object e = this.matchingTaskList.getSelectedValue();
        final JComponent[] jComponentArray = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.rakeTaskLabel, this.rakeTaskField, this.debugCheckbox, this.taskParamLabel, this.taskParametersComboBox, this.rakeTaskHint};
        this.setEnabled(jComponentArray, false);
        this.matchingTaskList.setListData(new Object[]{GrailsCommandChooser.getMessage("GrailsCommandChooser.reloading.tasks", new String[0])});
        this.project.getCommandSupport().refreshGrailsCommandsLater(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GrailsCommandChooser.this.reloadAllTasks();
                        GrailsCommandChooser.this.refreshTaskList();
                        GrailsCommandChooser.this.matchingTaskList.setSelectedValue(e, true);
                        runnable.run();
                        GrailsCommandChooser.this.setEnabled(jComponentArray, true);
                        GrailsCommandChooser.this.rakeTaskField.requestFocus();
                    }
                });
            }
        });
    }

    private void setEnabled(JComponent[] jComponentArray, boolean bl) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setEnabled(bl);
        }
    }

    private GrailsCommand getSelectedTask() {
        Object e = this.matchingTaskList.getSelectedValue();
        if (e != null && !NO_TASK_ITEM.equals(e)) {
            return (GrailsCommand)e;
        }
        return null;
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(GrailsCommandChooser.class, (String)string, (Object[])stringArray);
    }

    private void initComponents() {
        this.rakeTaskLabel = new JLabel();
        this.taskParamLabel = new JLabel();
        this.matchingTaskLabel = new JLabel();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.rakeTaskFieldPanel = new JPanel();
        this.rakeTaskField = new JTextField();
        this.rakeTaskHint = new JLabel();
        this.taskParametersComboBox = new JComboBox();
        this.debugCheckbox = new JCheckBox();
        this.rakeTaskLabel.setLabelFor(this.rakeTaskField);
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.taskParamLabel.text"));
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.matchingTaskLabel.text"));
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GrailsCommandChooser.this.matchingTaskListMouseClicked(mouseEvent);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        this.rakeTaskFieldPanel.setLayout(new BorderLayout());
        this.rakeTaskField.setText(NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskField.text"));
        this.rakeTaskField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                GrailsCommandChooser.this.rakeTaskFieldKeyPressed(keyEvent);
            }
        });
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskField, "North");
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskHint, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskHint.text"));
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskHint, "South");
        this.taskParametersComboBox.setEditable(true);
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.debugCheckbox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.matchingTaskSP, -1, 659, Short.MAX_VALUE).add(1, (Component)this.debugCheckbox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.taskParamLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.taskParametersComboBox, 0, 575, Short.MAX_VALUE).add((Component)this.rakeTaskFieldPanel, -1, 575, Short.MAX_VALUE))).add(1, (Component)this.matchingTaskLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.rakeTaskFieldPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.taskParamLabel).add((Component)this.taskParametersComboBox, -2, 21, -2)).addPreferredGap(1).add((Component)this.matchingTaskLabel).addPreferredGap(0).add((Component)this.matchingTaskSP, -1, 352, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.debugCheckbox).addContainerGap()));
    }

    private void handleNavigationKeys(KeyEvent keyEvent) {
        Object object = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        boolean bl = "selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object) || "selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object) || "scrollUp".equals(object) || "scrollUpExtendSelection".equals(object) || "scrollDown".equals(object) || "scrollDownExtendSelection".equals(object);
        int n = this.matchingTaskList.getSelectedIndex();
        ListModel listModel = this.matchingTaskList.getModel();
        int n2 = listModel.getSize();
        if ("selectNextRow".equals(object) && n == n2 - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(object) && n == 0) {
            int n3 = n2 - 1;
            this.matchingTaskList.setSelectedIndex(n3);
            this.matchingTaskList.ensureIndexIsVisible(n3);
            return;
        }
        if (bl) {
            Action action = this.matchingTaskList.getActionMap().get(object);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)object));
            keyEvent.consume();
        }
    }

    private void rakeTaskFieldKeyPressed(KeyEvent keyEvent) {
        this.handleNavigationKeys(keyEvent);
    }

    private void matchingTaskListMouseClicked(MouseEvent mouseEvent) {
        if (this.runButton.isEnabled() && mouseEvent.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    static {
        prjToTask = new HashMap<String, Map<GrailsCommand, ParameterContainer>>();
    }

    private static class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String string) {
            this.params.add(string);
        }

        public String getLastSelected() {
            return this.lastSelected;
        }

        public void setLastSelected(String string) {
            this.lastSelected = string;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    static final class Filter {
        private final String filter;
        private final List<GrailsCommand> tasks;

        private Filter(List<GrailsCommand> list, String string) {
            this.tasks = list;
            this.filter = string;
        }

        static List<GrailsCommand> getFilteredTasks(List<GrailsCommand> list, String string) {
            Filter filter = new Filter(list, string);
            return filter.filter();
        }

        private List<GrailsCommand> filter() {
            ArrayList<GrailsCommand> arrayList = new ArrayList<GrailsCommand>();
            Pattern pattern = this.getPattern();
            if (pattern != null) {
                for (GrailsCommand grailsCommand : this.tasks) {
                    Matcher matcher = pattern.matcher(grailsCommand.getCommand());
                    if (!matcher.matches()) continue;
                    arrayList.add(grailsCommand);
                }
            } else {
                ArrayList<GrailsCommand> arrayList2 = new ArrayList<GrailsCommand>();
                for (GrailsCommand grailsCommand : this.tasks) {
                    String string;
                    String string2 = grailsCommand.getCommand().toLowerCase(Locale.ENGLISH);
                    if (string2.startsWith(string = this.filter.toLowerCase(Locale.ENGLISH))) {
                        arrayList2.add(grailsCommand);
                        continue;
                    }
                    if (!string2.contains(string)) continue;
                    arrayList.add(grailsCommand);
                }
                arrayList.addAll(0, arrayList2);
            }
            return arrayList;
        }

        private Pattern getPattern() {
            if (this.filter.contains("?") || this.filter.contains("*")) {
                String string = Filter.removeRegexpEscapes(this.filter);
                string = string.replace(".", "\\.");
                string = string.replace("?", ".");
                string = string.replace("*", ".*");
                return Pattern.compile(".*" + string + ".*", 2);
            }
            return null;
        }

        private static String removeRegexpEscapes(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        continue block3;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
    }

    private static class GrailsCommandRenderer
    extends JLabel
    implements ListCellRenderer {
        public GrailsCommandRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3;
            this.setName("ComboBox.listRenderer");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                object3 = jList.getBackground();
                object2 = new Color(Math.abs(((Color)object3).getRed() - 10), Math.abs(((Color)object3).getGreen() - 10), Math.abs(((Color)object3).getBlue() - 10));
                this.setBackground((Color)(n % 2 == 0 ? object3 : object2));
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof GrailsCommand) {
                object3 = (GrailsCommand)object;
                object2 = ((GrailsCommand)object3).getDescription();
                StringBuilder stringBuilder = new StringBuilder("<html>");
                stringBuilder.append("<b>").append(((GrailsCommand)object3).getCommand()).append("</b>");
                if (object2 != null) {
                    stringBuilder.append(" : ").append((String)object2);
                }
                stringBuilder.append("</html>");
                this.setText(stringBuilder.toString());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    public static class CommandDescriptor {
        private final GrailsCommand task;
        private final String params;
        private final boolean debug;

        private CommandDescriptor(GrailsCommand grailsCommand, String string, boolean bl) {
            this.task = grailsCommand;
            this.params = string.length() == 0 ? null : string;
            this.debug = bl;
        }

        public GrailsCommand getGrailsCommand() {
            return this.task;
        }

        public String getCommandParams() {
            return this.params;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

