/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.ui.nodes.KenaiInstanceProperties;
import org.netbeans.modules.kenai.ui.nodes.LoginAction;
import org.netbeans.modules.kenai.ui.nodes.RemoveInstanceAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class KenaiInstanceNode
extends AbstractNode
implements PropertyChangeListener {
    private Kenai kenaiInstance;
    private KenaiInstanceProperties properties;

    public KenaiInstanceNode(Kenai instance) {
        super((Children)new Children.Array(), Lookups.singleton((Object)instance));
        this.kenaiInstance = instance;
        this.setName(this.kenaiInstance.getUrl().toString());
        instance.addPropertyChangeListener("url", (PropertyChangeListener)this);
        this.setDisplayName(instance.getName());
        this.setShortDescription(instance.getName() + " (" + instance.getUrl() + ")");
        this.properties = new KenaiInstanceProperties(instance.getName(), instance.getUrl().toString());
    }

    public Image getIcon(int type) {
        return ImageUtilities.icon2Image((Icon)this.kenaiInstance.getIcon());
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new LoginAction(this.kenaiInstance), new RemoveInstanceAction(this.kenaiInstance), SystemAction.get(PropertiesAction.class)};
    }

    public String getHtmlDisplayName() {
        return super.getHtmlDisplayName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireDisplayNameChange("", this.getHtmlDisplayName());
    }

    public void destroy() throws IOException {
        this.kenaiInstance.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[]{this.properties.getSheetSet()};
    }

    public boolean canCopy() {
        return false;
    }
}

