/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiPanel;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.openide.util.NbBundle;

public class KenaiFeatureCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel projectNameLabel;
    private JLabel projectRepoLabel;
    private JLabel repoTypeLabel;

    public KenaiFeatureCellRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectRepoLabel = new JLabel();
        this.repoTypeLabel = new JLabel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setText(NbBundle.getMessage(KenaiFeatureCellRenderer.class, (String)"KenaiFeatureCellRenderer.projectNameLabel.text"));
        this.projectNameLabel.setName("projectNameLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectRepoLabel.setText(NbBundle.getMessage(KenaiFeatureCellRenderer.class, (String)"KenaiFeatureCellRenderer.projectRepoLabel.text"));
        this.projectRepoLabel.setName("projectRepoLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.projectRepoLabel, gridBagConstraints);
        this.repoTypeLabel.setText(NbBundle.getMessage(KenaiFeatureCellRenderer.class, (String)"KenaiFeatureCellRenderer.repoTypeLabel.text"));
        this.repoTypeLabel.setName("repoTypeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.repoTypeLabel, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return new JLabel();
        }
        KenaiProject project = ((GetSourcesFromKenaiPanel.KenaiFeatureListItem)value).project;
        KenaiFeature feature = ((GetSourcesFromKenaiPanel.KenaiFeatureListItem)value).feature;
        if (feature != null) {
            if (index == -1) {
                this.projectNameLabel.setText(null);
                this.projectRepoLabel.setText(feature.getLocation());
                this.projectRepoLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.projectRepoLabel.setForeground(list.getForeground());
                this.repoTypeLabel.setText(null);
            } else {
                this.projectNameLabel.setText(project.getDisplayName() + " (" + project.getName() + ")");
                this.projectNameLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.projectNameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                this.projectRepoLabel.setText(feature.getLocation());
                this.projectRepoLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.projectRepoLabel.setForeground(isSelected ? list.getSelectionForeground() : ColorManager.getDefault().getLinkColor());
                this.repoTypeLabel.setText("(" + feature.getService() + ")");
                this.repoTypeLabel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.repoTypeLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            }
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        return this;
    }
}

