/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DataraceImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.DeadlockImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintCommand;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.LeaksStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.ThreadsStatistic;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

final class Erprint {
    private static final Pattern specPattern = Pattern.compile("[^:]*: (.*)");
    private static final Pattern sortPattern = Pattern.compile(".* \\( (.*) \\)");
    private static final Pattern choicePattern = Pattern.compile("^[ \t]+([0-9]+)\\) .*:0x([0-9a-f]+) +\\((.*)\\)");
    private static final String choiceMarker = "Available name list:";
    private final Logger log = DLightLogger.getLogger(Erprint.class);
    private final AtomicInteger locks = new AtomicInteger();
    private final NativeProcess process;
    private final InputStream out;
    private final InputStream err;
    private final OutputStream in;
    private final OutputProcessor outProcessor;
    private int currentLimit = -1;
    private boolean stopped = false;
    private final String logPrefix;

    Erprint(NativeProcessBuilder npb, int sessionID) throws IOException {
        this.process = npb.call();
        this.logPrefix = "er_print [" + this.process.getPID() + "]: ";
        this.addLock();
        String logFlag = System.getProperty("nativeexecution.support.logger.er_print");
        if (logFlag == null) {
            this.log.setLevel(Level.INFO);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(this.logPrefix + "started");
        }
        this.out = this.process.getInputStream();
        this.in = this.process.getOutputStream();
        this.err = this.process.getErrorStream();
        this.outProcessor = new OutputProcessor();
        this.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock() throws IllegalStateException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                throw new IllegalStateException("er_print is scheduled to be stopped already!");
            }
            this.locks.incrementAndGet();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock() {
        Erprint erprint = this;
        synchronized (erprint) {
            this.locks.decrementAndGet();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Erprint.this.log.isLoggable(Level.FINEST)) {
                    Erprint.this.log.finest(Erprint.this.logPrefix + "Scheduled for termination");
                }
                int attempts = 30;
                while (Erprint.this.locks.get() != 0 && --attempts > 0) {
                    try {
                        if (Erprint.this.log.isLoggable(Level.FINEST)) {
                            Erprint.this.log.finest(Erprint.this.logPrefix + "waiting for lock release [" + Erprint.this.locks.get() + "] ...");
                        }
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        if (!Erprint.this.log.isLoggable(Level.FINEST)) break;
                        Erprint.this.log.log(Level.FINEST, Erprint.this.logPrefix + "Exception while terminating", ex);
                        break;
                    }
                }
                if (Erprint.this.log.isLoggable(Level.FINEST)) {
                    if (Erprint.this.locks.get() > 0) {
                        Erprint.this.log.finest(Erprint.this.logPrefix + "do force termination");
                    } else {
                        Erprint.this.log.finest(Erprint.this.logPrefix + "do termination");
                    }
                }
                Erprint.this.process.destroy();
            }
        }, (String)("Stopping er_print " + this.logPrefix));
    }

    private void post(String cmd) throws IOException {
        this.in.write((cmd + "\n").getBytes());
        this.in.flush();
    }

    public synchronized int setLimit(int limit) throws IOException {
        if (this.currentLimit == limit) {
            return this.currentLimit;
        }
        int prevLimit = this.currentLimit;
        this.exec(ErprintCommand.limit(limit));
        this.currentLimit = limit;
        return prevLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metrics setMetrics(Metrics metrics) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            String[] data = this.exec(ErprintCommand.metrics());
            if (data == null || data.length != 2) {
                return null;
            }
            Matcher specMatcher = specPattern.matcher(data[0]);
            Matcher sortMatcher = sortPattern.matcher(data[1]);
            Metrics prevMetrics = null;
            if (specMatcher.matches() && sortMatcher.matches()) {
                prevMetrics = new Metrics(specMatcher.group(1), sortMatcher.group(1));
            }
            this.exec(ErprintCommand.metrics(metrics.mspec));
            this.exec(ErprintCommand.sort(metrics.msort));
            return prevMetrics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metrics getExperimentMetrics() throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            String[] data = this.exec(ErprintCommand.metrics());
            if (data == null || data.length != 2) {
                return null;
            }
            Matcher specMatcher = specPattern.matcher(data[0]);
            Matcher sortMatcher = sortPattern.matcher(data[1]);
            Metrics prevMetrics = null;
            if (specMatcher.matches() && sortMatcher.matches()) {
                prevMetrics = new Metrics(specMatcher.group(1), sortMatcher.group(1));
            }
            return prevMetrics;
        }
    }

    String[] getHotFunctions(ErprintCommand command, int limit) throws IOException {
        String[] stat = this.exec(command);
        ArrayList<String> result = new ArrayList<String>();
        for (String str : stat) {
            if (!str.matches("^ *[0-9]+.*") || str.contains("<Total>")) continue;
            result.add(str.trim());
            if (--limit == 0) break;
        }
        return result.toArray(new String[0]);
    }

    String[] getHotFunctions(int limit) throws IOException {
        return this.getHotFunctions(ErprintCommand.functions(), limit);
    }

    ExperimentStatistics getExperimentStatistics() throws IOException {
        String[] stat = this.exec(ErprintCommand.statistics());
        return new ExperimentStatistics(stat);
    }

    ThreadsStatistic getThreadsStatistics() throws IOException {
        String[] toParse = this.exec(ErprintCommand.thread_list());
        return new ThreadsStatistic(toParse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectObjects(CollectedObjectsFilter collectedObjectsFilter) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped || collectedObjectsFilter == null) {
                return;
            }
        }
        Pattern objs_pattern = Pattern.compile(".* <(.*)>.*");
        StringBuilder object_select = new StringBuilder();
        Erprint erprint2 = this;
        synchronized (erprint2) {
            String[] objects = this.exec(ErprintCommand.object_list());
            Collection<String> selectedObjects = collectedObjectsFilter.selectedObjects();
            Collection<String> hiddenObjects = collectedObjectsFilter.hiddenObjects();
            hiddenObjects.add("libcollector.so");
            hiddenObjects.add("er_heap.so");
            hiddenObjects.add("er_sync.so");
            hiddenObjects.add("Unknown");
            for (String o : objects) {
                String object;
                Matcher m = objs_pattern.matcher(o);
                if (!m.matches() || !selectedObjects.contains(object = m.group(1)) && hiddenObjects.contains(object)) continue;
                object_select.append(object).append(",");
            }
            if (object_select.length() != 0) {
                this.exec(ErprintCommand.object_select(object_select.toString()));
            }
        }
    }

    LeaksStatistics getExperimentLeaks() throws IOException {
        String[] stat = this.exec(ErprintCommand.leaks());
        return new LeaksStatistics(stat);
    }

    List<DataraceImpl> getDataRaces() throws IOException {
        String[] races = this.exec(ErprintCommand.rdetail_all());
        return DataraceImpl.fromErprint(races);
    }

    boolean setFilter(String filterString) throws IOException {
        String[] result = this.exec(ErprintCommand.filter(filterString == null ? "\"\"" : filterString));
        return result == null || result.length <= 0 || !result[0].startsWith("Error");
    }

    List<DeadlockImpl> getDeadlocks() throws IOException {
        String[] deadlocks = this.exec(ErprintCommand.ddetail_all());
        return DeadlockImpl.fromErprint(deadlocks);
    }

    FunctionStatistic getFunctionStatistic(String functionName) throws IOException {
        String[] stat = this.exec(ErprintCommand.fsingle(functionName, 1));
        return new FunctionStatistic(stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionStatistic getFunctionStatistic(FunctionCallImpl functionCall) throws IOException {
        FunctionStatistic result = new FunctionStatistic(new String[0]);
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return result;
            }
            String functionName = functionCall.getFunction().getName();
            String srcFile = functionCall.getSourceFile();
            String[] stat = this.exec(ErprintCommand.fsingle(functionName));
            String choice = "1";
            if (stat != null && stat.length > 0 && choiceMarker.equals(stat[0])) {
                long funcRef = functionCall.getFunctionRefID();
                for (String line : stat) {
                    Matcher m = choicePattern.matcher(line);
                    if (!m.matches()) continue;
                    choice = m.group(1);
                    String address = m.group(2);
                    String fname = m.group(3);
                    try {
                        if (Long.parseLong(address, 16) != funcRef && (srcFile == null || !fname.endsWith(srcFile))) continue;
                        break;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                this.post(choice);
                stat = this.outProcessor.getOutput();
            }
            result = new FunctionStatistic(stat == null ? new String[]{} : stat);
            if (stat != null) {
                this.refineSourceInfo(result, functionCall, Integer.parseInt(choice));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] exec(ErprintCommand command) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return new String[0];
            }
            long startTime = System.currentTimeMillis();
            try {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("> '" + command.getCmd() + "'");
                }
                this.post(command.getCmd());
            }
            catch (IOException ex) {
                this.stop();
                return new String[0];
            }
            String[] output = this.outProcessor.getOutput();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Command '" + command.getCmd() + "' done in " + (System.currentTimeMillis() - startTime) / 1000L + " secs. Response is " + output.length + " lines.");
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refineSourceInfo(FunctionStatistic fstat, FunctionCallImpl functionCall, int choice) throws IOException {
        String funcName = functionCall.getFunction().getName();
        long funcRef = functionCall.getFunctionRefID();
        if ("(unknown)".equals(fstat.getSourceFile())) {
            return;
        }
        Erprint erprint = this;
        synchronized (erprint) {
            Metrics prev_metrics = null;
            try {
                prev_metrics = this.setMetrics(Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_address), null));
                String[] stat = this.exec(ErprintCommand.source(funcName, choice));
                Pattern refPattern = Pattern.compile(".*:0x([0-9a-f]+) +([0-9]+).*");
                long delta = Long.MAX_VALUE;
                int closestLine = -1;
                for (String s : stat) {
                    if (s.startsWith("Source file:")) {
                        fstat.setSrcFile(s.substring(13).trim());
                        continue;
                    }
                    Matcher m = refPattern.matcher(s);
                    if (!m.matches()) continue;
                    try {
                        long ref = Long.parseLong(m.group(1), 16);
                        long new_delta = Math.abs(funcRef - ref);
                        if (new_delta >= delta) continue;
                        closestLine = Integer.parseInt(m.group(2));
                        if (new_delta == 0L) break;
                        delta = new_delta;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if (closestLine > 0) {
                    fstat.setSrcFileLine(closestLine);
                }
                if (prev_metrics == null) return;
            }
            catch (Throwable throwable) {
                if (prev_metrics == null) throw throwable;
                this.setMetrics(prev_metrics);
                throw throwable;
            }
            this.setMetrics(prev_metrics);
            {
            }
            return;
        }
    }

    private class OutputProcessor {
        private final ArrayList<String> resultBuffer = new ArrayList();
        private final StringBuilder lineBuffer = new StringBuilder();
        private final char[] prompt;
        private final char[] enterSelectionPrompt = "Enter selection: ".toCharArray();
        private final InputStream pis;

        public OutputProcessor() throws IOException {
            this.pis = Erprint.this.process.getInputStream();
            this.prompt = this.getPrompt();
        }

        public String[] getOutput() throws IOException {
            int c;
            int promptPos = 0;
            int enterSelectionPromptPos = 0;
            this.resultBuffer.clear();
            this.lineBuffer.setLength(0);
            while ((c = this.pis.read()) >= 0) {
                if (c == 10) {
                    this.resultBuffer.add(this.lineBuffer.toString());
                    this.lineBuffer.setLength(0);
                } else {
                    this.lineBuffer.append((char)c);
                }
                if (promptPos == this.prompt.length) break;
                if (this.prompt[promptPos] == c) {
                    if (++promptPos == this.prompt.length) {
                        break;
                    }
                } else {
                    promptPos = 0;
                }
                if (this.enterSelectionPrompt[enterSelectionPromptPos] == c) {
                    if (++enterSelectionPromptPos != this.enterSelectionPrompt.length) continue;
                    break;
                }
                enterSelectionPromptPos = 0;
            }
            return this.resultBuffer.toArray(new String[0]);
        }

        private char[] getPrompt() throws IOException {
            int currPos = 0;
            int pos1 = 0;
            int pos2 = 0;
            char[] parray = new char[4096];
            char[] result = null;
            try {
                int c;
                parray[0] = (char)Erprint.this.out.read();
                Erprint.this.post("");
                while ((c = Erprint.this.out.read()) >= 0) {
                    parray[++currPos] = (char)c;
                    if (parray[pos1] == parray[currPos]) {
                        if (pos2 == 0) {
                            pos2 = currPos;
                        }
                        if (++pos1 != pos2) continue;
                        break;
                    }
                    pos2 = 0;
                    pos1 = 0;
                }
                result = new char[pos1];
                System.arraycopy(parray, 0, result, 0, pos1);
            }
            catch (InterruptedIOException ex) {
                Thread.currentThread().interrupt();
                Erprint.this.stop();
                result = "<Terminated>".toCharArray();
            }
            return result;
        }
    }
}

