/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.options;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.options.LocalHistoryOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class LocalHistoryOptionsController
extends OptionsPanelController
implements DocumentListener {
    private final LocalHistoryOptionsPanel panel = new LocalHistoryOptionsPanel();

    public LocalHistoryOptionsController() {
        this.panel.warningLabel.setVisible(false);
        this.panel.daysTextField.getDocument().addDocumentListener(this);
    }

    public void update() {
        this.panel.daysTextField.setText(Long.toString(LocalHistorySettings.getInstance().getTTL()));
    }

    public void applyChanges() {
        if (!this.isValid()) {
            return;
        }
        LocalHistorySettings.getInstance().setTTL(Integer.parseInt(this.panel.daysTextField.getText()));
    }

    public void cancel() {
    }

    public boolean isValid() {
        boolean valid = true;
        try {
            Integer.parseInt(this.panel.daysTextField.getText());
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        this.panel.warningLabel.setVisible(!valid);
        return valid;
    }

    public boolean isChanged() {
        String ttl = Long.toString(LocalHistorySettings.getInstance().getTTL());
        return !ttl.equals(this.panel.daysTextField.getText());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isValid();
    }
}

