/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.RequiredBundleImpl;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

class PackageAdminImpl
implements PackageAdmin,
Runnable {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ExportedPackage)o2).getVersion().compareTo((Object)((ExportedPackage)o1).getVersion());
        }
    };
    private Felix m_felix = null;
    private Bundle[][] m_reqBundles = null;
    private Bundle m_systemBundle = null;
    private Thread m_thread = null;

    public PackageAdminImpl(Felix felix) {
        this.m_felix = felix;
        this.m_systemBundle = this.m_felix.getBundle(0L);
        this.m_thread = new Thread((Runnable)this, "FelixPackageAdmin");
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    synchronized void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
            this.notifyAll();
        }
    }

    public Bundle getBundle(Class clazz) {
        return this.m_felix.getBundle(clazz);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange vr = versionRange == null ? null : VersionRange.parse(versionRange);
        Bundle[] bundles = this.m_felix.getBundles();
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            String sym = bundles[i].getSymbolicName();
            if (sym == null || !sym.equals(symbolicName)) continue;
            Version v = ((BundleImpl)bundles[i]).getCurrentModule().getVersion();
            if (vr != null && !vr.isInRange(v)) continue;
            list.add(bundles[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        bundles = list.toArray(new Bundle[list.size()]);
        Arrays.sort(bundles, new Comparator(){

            public int compare(Object o1, Object o2) {
                Version v1 = ((BundleImpl)o1).getCurrentModule().getVersion();
                Version v2 = ((BundleImpl)o2).getCurrentModule().getVersion();
                return v2.compareTo((Object)v1);
            }
        });
        return bundles;
    }

    public int getBundleType(Bundle bundle) {
        Map headerMap = ((BundleImpl)bundle).getCurrentModule().getHeaders();
        if (headerMap.containsKey("Fragment-Host")) {
            return 1;
        }
        return 0;
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] pkgs = this.m_felix.getExportedPackages(name);
        if (pkgs == null || pkgs.length == 0) {
            return null;
        }
        Arrays.sort(pkgs, COMPARATOR);
        return pkgs[0];
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.m_felix.getExportedPackages(name);
        return pkgs == null || pkgs.length == 0 ? null : pkgs;
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        return this.m_felix.getExportedPackages(bundle);
    }

    public Bundle[] getFragments(Bundle bundle) {
        Bundle[] fragments = null;
        if ((this.getBundleType(bundle) & 1) == 0) {
            IModule[] modules = ((ModuleImpl)((BundleImpl)bundle).getCurrentModule()).getFragments();
            ArrayList<Bundle> list = new ArrayList<Bundle>();
            for (int i = 0; modules != null && i < modules.length; ++i) {
                Bundle b = modules[i].getBundle();
                if (b == null) continue;
                list.add(b);
            }
            fragments = list.size() == 0 ? null : list.toArray(new Bundle[list.size()]);
        }
        return fragments;
    }

    public Bundle[] getHosts(Bundle bundle) {
        if (this.getBundleType(bundle) == 1) {
            return this.m_felix.getDependentBundles((BundleImpl)bundle);
        }
        return null;
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        ArrayList<RequiredBundleImpl> list = new ArrayList<RequiredBundleImpl>();
        Bundle[] bundles = this.m_felix.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            BundleImpl impl = (BundleImpl)bundles[i];
            if (symbolicName != null && !symbolicName.equals(impl.getCurrentModule().getSymbolicName())) continue;
            list.add(new RequiredBundleImpl(this.m_felix, impl));
        }
        return list.size() == 0 ? null : list.toArray(new RequiredBundle[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPackages(Bundle[] bundles) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new AdminPermission(this.m_systemBundle, "resolve"));
        }
        PackageAdminImpl packageAdminImpl = this;
        synchronized (packageAdminImpl) {
            if (this.m_reqBundles == null) {
                this.m_reqBundles = new Bundle[][]{bundles};
            } else {
                Bundle[][] newReqBundles = new Bundle[this.m_reqBundles.length + 1][];
                System.arraycopy(this.m_reqBundles, 0, newReqBundles, 0, this.m_reqBundles.length);
                newReqBundles[this.m_reqBundles.length] = bundles;
                this.m_reqBundles = newReqBundles;
            }
            this.notifyAll();
        }
    }

    public boolean resolveBundles(Bundle[] bundles) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new AdminPermission(this.m_systemBundle, "resolve"));
        }
        return this.m_felix.resolveBundles(bundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Bundle[] bundles = null;
            PackageAdminImpl packageAdminImpl = this;
            synchronized (packageAdminImpl) {
                while (this.m_reqBundles == null) {
                    if (this.m_thread == null) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                bundles = this.m_reqBundles[0];
            }
            this.m_felix.refreshPackages(bundles);
            packageAdminImpl = this;
            synchronized (packageAdminImpl) {
                if (this.m_reqBundles.length == 1) {
                    this.m_reqBundles = null;
                } else {
                    Bundle[][] newReqBundles = new Bundle[this.m_reqBundles.length - 1][];
                    System.arraycopy(this.m_reqBundles, 1, newReqBundles, 0, this.m_reqBundles.length - 1);
                    this.m_reqBundles = newReqBundles;
                }
            }
        }
    }
}

