/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.testrunner.PhpTestRunnerNodeFactory;
import org.netbeans.modules.php.project.ui.testrunner.PhpUnitLogParser;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionVO;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public final class UnitTestRunner {
    private static final Logger LOGGER = Logger.getLogger(UnitTestRunner.class.getName());
    private static final Manager MANAGER = Manager.getInstance();
    private static final PhpOutputLineHandler PHP_OUTPUT_LINE_HANDLER = new PhpOutputLineHandler();
    private final PhpProject project;
    private final TestSession testSession;
    private final boolean allTests;
    private volatile boolean started = false;

    public UnitTestRunner(PhpProject project, TestSession.SessionType sessionType, RerunHandler rerunHandler, boolean allTests) {
        assert (project != null);
        assert (sessionType != null);
        assert (rerunHandler != null);
        this.project = project;
        this.allTests = allTests;
        this.testSession = new TestSession("PHPUnit test session", (Project)project, sessionType, (TestRunnerNodeFactory)new PhpTestRunnerNodeFactory());
        this.testSession.setRerunHandler(rerunHandler);
        this.testSession.setOutputLineHandler((OutputLineHandler)PHP_OUTPUT_LINE_HANDLER);
    }

    public void start() {
        MANAGER.testStarted(this.testSession);
        this.started = true;
    }

    public void showResults() {
        File customSuite;
        BufferedReader reader;
        if (!this.started) {
            throw new IllegalStateException("Test runner must be started. Call start() method first.");
        }
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PhpUnit.XML_LOG), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        catch (FileNotFoundException ex) {
            this.processPhpUnitError();
            return;
        }
        TestSessionVO session = new TestSessionVO();
        PhpUnitLogParser.parse(reader, session);
        if (!PhpUnit.KEEP_LOGS) {
            PhpUnit.XML_LOG.delete();
        }
        if (this.allTests && (customSuite = PhpUnit.getCustomSuite(this.project)) != null) {
            MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_CustomSuiteUsed", (Object)customSuite.getAbsolutePath()), false);
            MANAGER.displayOutput(this.testSession, "", false);
        }
        for (TestSessionVO.TestSuiteVO suite : session.getTestSuites()) {
            MANAGER.displaySuiteRunning(this.testSession, suite.getName());
            TestSuite testSuite = new TestSuite(suite.getName());
            this.testSession.addSuite(testSuite);
            for (TestSessionVO.TestCaseVO kase : suite.getTestCases()) {
                Testcase testCase = new Testcase(kase.getName(), "PHPUnit test case", this.testSession);
                testCase.setTimeMillis(kase.getTime());
                testCase.setStatus(kase.getStatus());
                String[] stacktrace = kase.getStacktrace();
                if (stacktrace.length > 0) {
                    boolean isError = kase.isError();
                    Trouble trouble = new Trouble(isError);
                    trouble.setStackTrace(stacktrace);
                    testCase.setTrouble(trouble);
                    MANAGER.displayOutput(this.testSession, suite.getName() + "::" + kase.getName() + "()", isError);
                    this.testSession.addOutput("<u>" + kase.getName() + ":</u>");
                    for (String s : stacktrace) {
                        MANAGER.displayOutput(this.testSession, s, isError);
                        this.testSession.addOutput(s);
                    }
                    MANAGER.displayOutput(this.testSession, "", false);
                    this.testSession.addOutput("");
                }
                this.testSession.addTestCase(testCase);
            }
            MANAGER.displayReport(this.testSession, this.testSession.getReport(suite.getTime()));
        }
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_OutputInOutput"), false);
        MANAGER.sessionFinished(this.testSession);
    }

    private void processPhpUnitError() {
        LOGGER.info(String.format("File %s not found. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.XML_LOG));
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_PerhapsError"), true);
        MANAGER.sessionFinished(this.testSession);
    }

    private static final class PhpOutputLineHandler
    implements OutputLineHandler {
        private static final LineConvertor CONVERTOR = LineConvertors.filePattern(null, (Pattern)PhpUnit.LINE_PATTERN, null, (int)1, (int)2);

        private PhpOutputLineHandler() {
        }

        public void handleLine(OutputWriter out, String text) {
            LineProcessors.printing((OutputWriter)out, (LineConvertor)CONVERTOR, (boolean)true).processLine(text);
        }
    }
}

