/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RunAsValidator {
    private static final String INVALID_SEPARATOR = "\\";

    private RunAsValidator() {
    }

    public static String validateWebFields(String url, File webRoot, String indexFile, String arguments) {
        String err = null;
        err = !Utils.isValidUrl(url) ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl") : (!url.endsWith("/") ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_UrlNotTrailingSlash") : RunAsValidator.validateIndexFile(webRoot, indexFile, arguments));
        return err;
    }

    public static String validateScriptFields(String phpInterpreter, File projectDirectory, String indexFile, String arguments) {
        try {
            PhpInterpreter.getCustom((String)phpInterpreter);
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            return ex.getLocalizedMessage();
        }
        return RunAsValidator.validateIndexFile(projectDirectory, indexFile, arguments);
    }

    public static String validateUploadDirectory(String uploadDirectory, boolean allowEmpty) {
        if (allowEmpty && !StringUtils.hasText((String)uploadDirectory)) {
            return null;
        }
        if (!StringUtils.hasText((String)uploadDirectory)) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_MissingUploadDirectory");
        }
        if (!uploadDirectory.startsWith("/")) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryStart", (Object)"/");
        }
        if (uploadDirectory.contains(INVALID_SEPARATOR)) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryContent", (Object)INVALID_SEPARATOR);
        }
        return null;
    }

    public static String sanitizeUploadDirectory(String uploadDirectory, boolean allowEmpty) {
        if (StringUtils.hasText((String)uploadDirectory)) {
            while (uploadDirectory.length() > 1 && uploadDirectory.endsWith("/")) {
                uploadDirectory = uploadDirectory.substring(0, uploadDirectory.length() - 1);
            }
        } else if (!allowEmpty) {
            uploadDirectory = "/";
        }
        if (allowEmpty && "/".equals(uploadDirectory)) {
            uploadDirectory = "";
        }
        return uploadDirectory;
    }

    public static String validateIndexFile(File parentDirectory, String indexFile, String arguments) {
        assert (parentDirectory != null);
        if (indexFile != null) {
            if (!StringUtils.hasText((String)indexFile)) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_NoIndexFile");
            }
            indexFile = indexFile.trim();
            boolean error = false;
            if (indexFile.startsWith("/") || indexFile.startsWith(INVALID_SEPARATOR)) {
                error = true;
            } else if (Utilities.isWindows() && indexFile.contains(File.separator)) {
                error = true;
            } else {
                File index = new File(parentDirectory, indexFile.replace('/', File.separatorChar));
                if (!index.isFile() || !index.equals(FileUtil.normalizeFile((File)index))) {
                    error = true;
                }
            }
            if (error) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_IndexFileInvalid");
            }
        }
        return null;
    }

    public static String composeUrlHint(String baseURL, String indexFile, String args) throws InvalidUrlException {
        URL retval = null;
        try {
            if (baseURL != null && baseURL.trim().length() > 0) {
                retval = new URL(baseURL);
            }
            if (retval != null && indexFile != null && indexFile.trim().length() > 0) {
                retval = new URL(retval, indexFile);
            }
            if (retval != null && args != null && args.trim().length() > 0) {
                retval = new URI(retval.getProtocol(), retval.getUserInfo(), retval.getHost(), retval.getPort(), retval.getPath(), args, retval.getRef()).toURL();
            }
        }
        catch (MalformedURLException ex) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        catch (URISyntaxException ex) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        return retval != null ? retval.toExternalForm() : "";
    }

    public static final class InvalidUrlException
    extends Exception {
        private static final long serialVersionUID = 1234514014505423742L;

        public InvalidUrlException(String message) {
            super(message);
        }
    }
}

