/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AskForUrlPanel
extends JPanel {
    private static final long serialVersionUID = 9261149997804215L;
    private final PhpProject project;
    private final JTextField urlComboBoxEditor;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport;
    private JComboBox urlComboBox;
    private JLabel urlLabel;

    AskForUrlPanel(PhpProject project, URL defaultUrl) {
        assert (project != null);
        assert (defaultUrl != null);
        this.project = project;
        this.initComponents();
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        urls.add(defaultUrl.toExternalForm());
        urls.addAll(ProjectSettings.getDebugUrls(project));
        for (String s : urls) {
            this.urlComboBox.addItem(s);
        }
        this.urlComboBoxEditor = (JTextField)this.urlComboBox.getEditor().getEditorComponent();
        this.urlComboBoxEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AskForUrlPanel.this.validateFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AskForUrlPanel.this.validateFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AskForUrlPanel.this.validateFields();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        boolean ok;
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(AskForUrlPanel.class, (String)"LBL_SpecifyUrl"), true, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            this.validateFields();
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        boolean bl = ok = this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
        if (ok) {
            LinkedHashSet<String> urls = new LinkedHashSet<String>();
            urls.add((String)this.urlComboBox.getSelectedItem());
            for (int i = 1; i < this.urlComboBox.getItemCount(); ++i) {
                urls.add((String)this.urlComboBox.getItemAt(i));
            }
            ProjectSettings.setDebugUrls(this.project, new ArrayList<String>(urls));
        }
        return ok;
    }

    public URL getUrl() {
        try {
            return new URL((String)this.urlComboBox.getSelectedItem());
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("The URL must already be valid!", ex);
        }
    }

    void validateFields() {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        String url = this.urlComboBoxEditor.getText();
        if (!Utils.isValidUrl(url)) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(AskForUrlPanel.class, (String)"MSG_InvalidUrl"));
            this.descriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return AskForUrlPanel.this.urlComboBox;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return AskForUrlPanel.this.urlComboBox;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return AskForUrlPanel.this.urlComboBox;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                return AskForUrlPanel.this.urlComboBox;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                return AskForUrlPanel.this.urlComboBox;
            }
        });
        this.urlLabel.setLabelFor(this.urlComboBox);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlLabel.text"));
        this.urlComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.urlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlComboBox, 0, 341, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlComboBox.AccessibleContext.accessibleName"));
        this.urlComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlComboBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.AccessibleContext.accessibleDescription"));
    }
}

