/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakefileOrConfigureDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ParserConfigurationDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModeDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFoldersDescriptorPanel;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NewMakeProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_PROJECT_NAME = "CppApplication";
    public static final String DYNAMICLIBRARY_PROJECT_NAME = "CppDynamicLibrary";
    public static final String STATICLIBRARY_PROJECT_NAME = "CppStaticLibrary";
    public static final String MAKEFILEPROJECT_PROJECT_NAME = "MakefileProject";
    public static final String QTAPPLICATION_PROJECT_NAME = "QtApplication";
    public static final String QTDYNAMICLIBRARY_PROJECT_NAME = "QtDynamicLibrary";
    public static final String QTSTATICLIBRARY_PROJECT_NAME = "QtStaticLibrary";
    static final String PROP_NAME_INDEX = "nameIndex";
    public static final int TYPE_MAKEFILE = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    private int wizardtype;
    private String name;
    private String wizardTitle;
    private String wizardACSD;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor.Panel[] simplePanels;
    private transient WizardDescriptor wiz;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private static ResourceBundle bundle;

    private NewMakeProjectWizardIterator(int wizardtype, String name, String wizardTitle, String wizardACSD) {
        this.wizardtype = wizardtype;
        this.name = name;
        this.wizardTitle = wizardTitle;
        this.wizardACSD = wizardACSD;
    }

    public static NewMakeProjectWizardIterator newApplication() {
        String name = APPLICATION_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newApplication.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewLibraryACSD");
        return new NewMakeProjectWizardIterator(1, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newDynamicLibrary() {
        String name = DYNAMICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newDynamicLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewDynamicLibraryACSD");
        return new NewMakeProjectWizardIterator(2, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newStaticLibrary() {
        String name = STATICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newStaticLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewStaticLibraryACSD");
        return new NewMakeProjectWizardIterator(3, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtApplication() {
        String name = QTAPPLICATION_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtApplication.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtApplicationACSD");
        return new NewMakeProjectWizardIterator(4, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtDynamicLibrary() {
        String name = QTDYNAMICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtDynamicLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtDynamicLibraryACSD");
        return new NewMakeProjectWizardIterator(5, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtStaticLibrary() {
        String name = QTSTATICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtStaticLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtStaticLibraryACSD");
        return new NewMakeProjectWizardIterator(6, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator makefile() {
        String name = MAKEFILEPROJECT_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/makefile.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeMakefileNameACSD");
        return new NewMakeProjectWizardIterator(0, name, wizardTitle, wizardACSD);
    }

    private WizardDescriptor.Panel[] createPanels(String name) {
        if (this.wizardtype == 1 || this.wizardtype == 2 || this.wizardtype == 3 || this.wizardtype == 4 || this.wizardtype == 5 || this.wizardtype == 6) {
            return new WizardDescriptor.Panel[]{new PanelConfigureProject(name, this.wizardtype, this.wizardTitle, this.wizardACSD, true)};
        }
        if (this.wizardtype == 0) {
            return new WizardDescriptor.Panel[]{new SelectModeDescriptorPanel(), new MakefileOrConfigureDescriptorPanel(), new BuildActionsDescriptorPanel(), new SourceFoldersDescriptorPanel(), new ParserConfigurationDescriptorPanel(), new PanelConfigureProject(name, this.wizardtype, this.wizardTitle, this.wizardACSD, false)};
        }
        return null;
    }

    private String[] createSteps(WizardDescriptor.Panel[] panels) {
        int i;
        String[] steps = new String[panels.length];
        for (i = 0; i < panels.length; ++i) {
            steps[i] = panels[i] instanceof Name ? ((Name)panels[i]).getName() : panels[i].getComponent().getName();
        }
        for (i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        return steps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set<FileObject> set = this.instantiate();
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        String hostUID = (String)this.wiz.getProperty("hostUID");
        CompilerSet toolchain = (CompilerSet)this.wiz.getProperty("toolchain");
        if (dirF != null) {
            dirF = CndFileUtils.normalizeFile((File)dirF);
        }
        String projectName = (String)this.wiz.getProperty("name");
        String makefileName = (String)this.wiz.getProperty("makefilename");
        if (this.isSimple()) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                SelectModeDescriptorPanel importPanel = (SelectModeDescriptorPanel)this.simplePanels[0];
                resultSet.addAll(extension.createProject(new SelectModeDescriptorPanel.WizardDescriptorAdapter(importPanel.getWizardStorage())));
            }
        } else if (this.wizardtype == 0) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                resultSet.addAll(extension.createProject(this.wiz));
            }
        } else if (this.wizardtype == 1 || this.wizardtype == 2 || this.wizardtype == 3 || this.wizardtype == 4 || this.wizardtype == 5 || this.wizardtype == 6) {
            int conftype = -1;
            if (this.wizardtype == 1) {
                conftype = 1;
            } else if (this.wizardtype == 2) {
                conftype = 2;
            } else if (this.wizardtype == 3) {
                conftype = 3;
            } else if (this.wizardtype == 4) {
                conftype = 4;
            } else if (this.wizardtype == 5) {
                conftype = 5;
            } else if (this.wizardtype == 6) {
                conftype = 6;
            }
            String mainFile = null;
            if (((Boolean)this.wiz.getProperty("createMainFile")).booleanValue()) {
                String fname = (String)this.wiz.getProperty("mainFileName");
                String template = (String)this.wiz.getProperty("mainFileTemplate");
                mainFile = fname + "|" + template;
            }
            MakeConfiguration debug = new MakeConfiguration(dirF.getPath(), "Debug", conftype, hostUID, toolchain);
            debug.getCCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getCCCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getFortranCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getAssemblerConfiguration().getDevelopmentMode().setValue(1);
            debug.getQmakeConfiguration().getBuildMode().setValue(0);
            MakeConfiguration release = new MakeConfiguration(dirF.getPath(), "Release", conftype, hostUID, toolchain);
            release.getCCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getCCCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getFortranCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getAssemblerConfiguration().getDevelopmentMode().setValue(5);
            release.getQmakeConfiguration().getBuildMode().setValue(1);
            MakeConfiguration[] confs = new MakeConfiguration[]{debug, release};
            ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, dirF);
            prjParams.setMakefileName(makefileName);
            prjParams.setConfigurations(confs);
            prjParams.setMainFile(mainFile);
            MakeProjectGenerator.createProject(prjParams);
            ConfigurationDescriptorProvider.recordCreatedProjectMetrics(confs);
            FileObject dir = FileUtil.toFileObject((File)dirF);
            resultSet.add(dir);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(this.name.replaceAll(" ", ""));
        String[] steps = this.createSteps(this.panels);
        if (this.wizardtype == 0) {
            this.simplePanels = new WizardDescriptor.Panel[]{this.panels[0]};
            steps = this.createSteps(this.simplePanels);
            String[] advanced = new String[]{steps[0], "..."};
            Component c = this.panels[0].getComponent();
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentData", advanced);
            }
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        if (this.wizardtype == 0) {
            this.wiz.putProperty("sourceRoot", null);
        }
        this.wiz = null;
        this.panels = null;
        this.simplePanels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewMakeProjectWizardIterator.class, (String)"LAB_IteratorName"), this.index + 1, this.panels.length);
    }

    private boolean isSimple() {
        return this.wizardtype == 0 && Boolean.TRUE.equals(this.wiz.getProperty("simpleMode"));
    }

    public boolean hasNext() {
        if (this.isSimple()) {
            return this.index < this.simplePanels.length - 1;
        }
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        if (this.isSimple()) {
            return this.simplePanels[this.index];
        }
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NewMakeProjectWizardIterator.class);
        }
        return bundle.getString(s);
    }

    static interface Name {
        public String getName();
    }
}

