/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerListUI;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class RemoteDevelopmentAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final String HOST_ENV = "org.netbeans.modules.cnd.makeproject.ui.RemoteHost";
    private static final String CONF = "org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration";
    private static final String PROJECT = "org.netbeans.modules.cnd.makeproject.api.configurations.MakeProject";
    private JMenu subMenu;
    private MakeProject project;

    public RemoteDevelopmentAction(MakeProject project) {
        super(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name"), null);
        this.project = project;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        if (this.subMenu == null) {
            String label = NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_RemoteDevelopmentAction_Name");
            this.subMenu = new JMenu(label);
        }
        this.subMenu.removeAll();
        final MakeConfiguration mconf = this.project.getActiveConfiguration();
        ExecutionEnvironment currExecEnv = this.project.getDevelopmentHostExecutionEnvironment();
        if (mconf == null || currExecEnv == null) {
            return;
        }
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        for (ServerRecord record : ServerList.getRecords()) {
            JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(record.getServerDisplayName(), currExecEnv.equals(record.getExecutionEnvironment()));
            this.subMenu.add(jmi);
            jmi.putClientProperty(HOST_ENV, record.getExecutionEnvironment());
            jmi.putClientProperty(CONF, mconf);
            jmi.putClientProperty(PROJECT, this.project);
            jmi.addActionListener(jmiActionListener);
        }
        this.subMenu.add(new JSeparator());
        final JMenuItem managePlatformsItem = new JMenuItem(NbBundle.getMessage(RemoteDevelopmentAction.class, (String)"LBL_ManagePlatforms_Name"));
        this.subMenu.add(managePlatformsItem);
        managePlatformsItem.addActionListener(new ActionListener(){
            private MakeProject currProject;
            {
                this.currProject = RemoteDevelopmentAction.this.project;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ExecutionEnvironment env;
                AtomicReference selectedEnv = new AtomicReference();
                if (ServerListUI.showServerListDialog(selectedEnv) && (env = (ExecutionEnvironment)selectedEnv.get()) != null) {
                    RemoteDevelopmentAction.setRemodeDevelopmentHost(managePlatformsItem, mconf, env, RemoteDevelopmentAction.this.project);
                }
            }
        });
    }

    private static void setRemodeDevelopmentHost(final Object source, final MakeConfiguration mconf, final ExecutionEnvironment execEnv, final Project project) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    RemoteDevelopmentAction._setRemodeDevelopmentHost(source, mconf, execEnv, project);
                }
            });
        } else {
            RemoteDevelopmentAction._setRemodeDevelopmentHost(source, mconf, execEnv, project);
        }
    }

    private static void _setRemodeDevelopmentHost(Object source, MakeConfiguration mconf, ExecutionEnvironment execEnv, Project project) {
        if (mconf != null && execEnv != null) {
            ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
            if (!record.isSetUp() && !record.setUp()) {
                return;
            }
            DevelopmentHostConfiguration dhc = new DevelopmentHostConfiguration(execEnv);
            DevelopmentHostConfiguration oldDhc = mconf.getDevelopmentHost();
            if (dhc.getExecutionEnvironment() == oldDhc.getExecutionEnvironment()) {
                return;
            }
            mconf.setDevelopmentHost(dhc);
            CompilerSet2Configuration oldCS = mconf.getCompilerSet();
            String oldCSName = oldCS.getName();
            CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)dhc.getExecutionEnvironment());
            CompilerSet newCS = csm.getCompilerSet(oldCSName);
            newCS = newCS == null ? csm.getDefaultCompilerSet() : newCS;
            mconf.setCompilerSet(new CompilerSet2Configuration(dhc, newCS));
            NativeProjectProvider npp = (NativeProjectProvider)project.getLookup().lookup(NativeProjectProvider.class);
            npp.propertyChange(new PropertyChangeEvent(source, "activeconfiguration", null, mconf));
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor configurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            ((ConfigurationDescriptor)configurationDescriptor).setModified();
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                ExecutionEnvironment execEnv = (ExecutionEnvironment)jmi.getClientProperty(RemoteDevelopmentAction.HOST_ENV);
                MakeConfiguration mconf = (MakeConfiguration)jmi.getClientProperty(RemoteDevelopmentAction.CONF);
                Project project = (Project)jmi.getClientProperty(RemoteDevelopmentAction.PROJECT);
                RemoteDevelopmentAction.setRemodeDevelopmentHost(jmi, mconf, execEnv, project);
            }
        }
    }
}

