/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;

public class MakeProjectFileProviderFactory
implements FileProviderFactory {
    private static final ConcurrentMap<Project, Map<Folder, List<CharSequence>>> searchBase = new ConcurrentHashMap<Project, Map<Folder, List<CharSequence>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSearchBase(Project project, Folder folder, List<CharSequence> list) {
        Map old;
        Map<Folder, List<Object>> projectSearchBase = (ConcurrentHashMap<Folder, List<Object>>)searchBase.get(project);
        if (projectSearchBase == null && (old = (Map)searchBase.putIfAbsent(project, projectSearchBase = new ConcurrentHashMap<Folder, List<Object>>())) != null) {
            projectSearchBase = old;
        }
        ConcurrentHashMap<Folder, List<Object>> concurrentHashMap = projectSearchBase;
        synchronized (concurrentHashMap) {
            if (list == null) {
                projectSearchBase.remove(folder);
            } else if (list.isEmpty()) {
                projectSearchBase.put(folder, Collections.emptyList());
            } else {
                projectSearchBase.put(folder, list);
            }
        }
    }

    public static void removeSearchBase(Project project) {
        searchBase.remove(project);
    }

    public String name() {
        return "CND FileProviderFactory";
    }

    public String getDisplayName() {
        return this.name();
    }

    public FileProvider createFileProvider() {
        return new FileProviderImpl();
    }

    private static final class OtherFD
    extends FileDescriptor {
        private final String name;
        private final Project project;
        private final Folder folder;
        private final String baseDir;

        public OtherFD(String name, Project project, String baseDir, Folder folder) {
            this.name = name;
            this.project = project;
            this.folder = folder;
            this.baseDir = baseDir;
        }

        public String getFileName() {
            return this.name;
        }

        public String getOwnerPath() {
            return this.folder.getPath();
        }

        public Icon getIcon() {
            DataObject od = this.getDataObject();
            if (od != null) {
                Image i = od.getNodeDelegate().getIcon(1);
                return new ImageIcon(i);
            }
            return null;
        }

        public String getProjectName() {
            return ((MakeProject)this.project).getName();
        }

        public Icon getProjectIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
        }

        public void open() {
            DataObject od = this.getDataObject();
            if (od != null) {
                EditCookie ec = (EditCookie)od.getCookie(EditCookie.class);
                if (ec != null) {
                    ec.edit();
                } else {
                    OpenCookie oc = (OpenCookie)od.getCookie(OpenCookie.class);
                    if (oc != null) {
                        oc.open();
                    }
                }
            }
        }

        private DataObject getDataObject() {
            try {
                FileObject fo = this.getFileObject();
                if (fo != null) {
                    return DataObject.find((FileObject)fo);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return null;
        }

        public FileObject getFileObject() {
            String AbsRootPath = CndPathUtilitities.toAbsolutePath((String)this.baseDir, (String)this.folder.getRootPath());
            File file = new File(AbsRootPath, this.name);
            return FileUtil.toFileObject((File)file);
        }
    }

    private static final class ItemFD
    extends FileDescriptor {
        private final Item item;
        private final Project project;

        public ItemFD(Item item, Project project) {
            this.item = item;
            this.project = project;
        }

        public String getFileName() {
            return this.item.getName();
        }

        public String getOwnerPath() {
            StringBuilder out = new StringBuilder();
            for (Folder parent = this.item.getFolder(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
                if (out.length() > 0) {
                    out.insert(0, "/");
                }
                out.insert(0, parent.getDisplayName());
            }
            return out.toString();
        }

        public Icon getIcon() {
            DataObject od = this.item.getDataObject();
            if (od != null) {
                Image i = od.getNodeDelegate().getIcon(1);
                return new ImageIcon(i);
            }
            return null;
        }

        public String getProjectName() {
            return ((MakeProject)this.project).getName();
        }

        public Icon getProjectIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
        }

        public void open() {
            DataObject od = this.item.getDataObject();
            if (od != null) {
                EditCookie ec = (EditCookie)od.getCookie(EditCookie.class);
                if (ec != null) {
                    ec.edit();
                } else {
                    OpenCookie oc = (OpenCookie)od.getCookie(OpenCookie.class);
                    if (oc != null) {
                        oc.open();
                    }
                }
            }
        }

        public FileObject getFileObject() {
            return this.item.getFileObject();
        }
    }

    private class FileProviderImpl
    implements FileProvider {
        private final AtomicBoolean cancel = new AtomicBoolean();

        public boolean computeFiles(FileProvider.Context context, FileProvider.Result result) {
            if (!MakeOptions.getInstance().isFullFileIndexer()) {
                this.cancel.set(false);
                Project project = context.getProject();
                ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                if (provider != null && provider.gotDescriptor()) {
                    MakeConfigurationDescriptor descriptor = provider.getConfigurationDescriptor();
                    Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
                    SourceGroup[] genericSG = srcs.getSourceGroups("generic");
                    if (genericSG != null && genericSG.length > 0 && genericSG[0].getRootFolder().equals(context.getRoot())) {
                        NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)context.getText(), (SearchType)context.getSearchType());
                        this.computeFiles(project, descriptor, matcher, result);
                    }
                    return true;
                }
            }
            return false;
        }

        public void cancel() {
            this.cancel.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeFiles(Project project, MakeConfigurationDescriptor descriptor, NameMatcher matcher, FileProvider.Result result) {
            FileObject projectDirectoryFO = project.getProjectDirectory();
            if (projectDirectoryFO != null) {
                FileObject nbFO = projectDirectoryFO.getFileObject("nbproject");
                this.computeFOs(nbFO, matcher, result);
            }
            for (Item item : descriptor.getExternalFileItemsAsArray()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(item.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD(item, project));
            }
            for (Item item : descriptor.getProjectItems()) {
                if (this.cancel.get()) {
                    return;
                }
                if (!matcher.accept(item.getName())) continue;
                result.addFileDescriptor((FileDescriptor)new ItemFD(item, project));
            }
            HashMap projectSearchBase = (HashMap)searchBase.get(project);
            if (projectSearchBase != null) {
                HashMap len$ = projectSearchBase;
                synchronized (len$) {
                    projectSearchBase = new HashMap(projectSearchBase);
                }
                String baseDir = descriptor.getBaseDir();
                for (Map.Entry entry : projectSearchBase.entrySet()) {
                    if (this.cancel.get()) {
                        return;
                    }
                    Folder folder = (Folder)entry.getKey();
                    List files = (List)entry.getValue();
                    if (files == null) continue;
                    for (CharSequence name : files) {
                        if (this.cancel.get()) {
                            return;
                        }
                        if (!matcher.accept(((Object)name).toString())) continue;
                        result.addFileDescriptor((FileDescriptor)new OtherFD(((Object)name).toString(), project, baseDir, folder));
                    }
                }
            }
        }

        private void computeFOs(FileObject nbFO, NameMatcher matcher, FileProvider.Result result) {
            if (nbFO != null) {
                assert (nbFO.isFolder());
                for (FileObject fileObject : nbFO.getChildren()) {
                    if (fileObject.isFolder()) {
                        this.computeFOs(fileObject, matcher, result);
                        continue;
                    }
                    if (!matcher.accept(fileObject.getNameExt())) continue;
                    result.addFile(fileObject);
                }
            }
        }
    }
}

