/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinTokenListBase;

public final class EmbeddedJoinInfo {
    public final JoinTokenListBase base;
    int rawJoinTokenIndex;
    int rawTokenListIndex;
    private int joinTokenLastPartShift;

    public EmbeddedJoinInfo(JoinTokenListBase base, int rawJoinTokenIndex, int rawTokenListIndex) {
        assert (base != null);
        this.base = base;
        this.rawJoinTokenIndex = rawJoinTokenIndex;
        this.rawTokenListIndex = rawTokenListIndex;
    }

    public int joinTokenIndex() {
        return this.base.joinTokenIndex(this.rawJoinTokenIndex);
    }

    public void setRawJoinTokenIndex(int rawJoinTokenIndex) {
        this.rawJoinTokenIndex = rawJoinTokenIndex;
    }

    public int tokenListIndex() {
        return this.base.tokenListIndex(this.rawTokenListIndex);
    }

    public int joinTokenLastPartShift() {
        return this.joinTokenLastPartShift;
    }

    public void setJoinTokenLastPartShift(int joinTokenLastPartShift) {
        this.joinTokenLastPartShift = joinTokenLastPartShift;
    }

    public StringBuilder dumpInfo(StringBuilder sb, EmbeddedTokenList<?> etl) {
        if (sb == null) {
            sb = new StringBuilder(70);
        }
        sb.append("<").append(this.joinTokenIndex()).append(",");
        if (etl != null) {
            sb.append(this.joinTokenIndex() + etl.joinTokenCount());
        } else {
            sb.append("?");
        }
        sb.append(">, tli=").append(this.tokenListIndex());
        sb.append(", lps=").append(this.joinTokenLastPartShift());
        return sb;
    }

    public String toString() {
        return this.dumpInfo(null, null).toString();
    }
}

