/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsConfigurationHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class JavaMELibsPreviewHelper
extends JavaMELibsConfigurationHelper {
    public static List<String> extractLibraryJarsPaths(Library library, String libName) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<URL> it = null;
        it = library.getContent("classpath").iterator();
        list.addAll(JavaMELibsPreviewHelper.getFinalJarsPaths(it, "release/libs/", libName));
        it = library.getContent("src").iterator();
        list.addAll(JavaMELibsPreviewHelper.getFinalJarsPaths(it, "release/sources/", libName));
        it = library.getContent("javadoc").iterator();
        list.addAll(JavaMELibsPreviewHelper.getFinalJarsPaths(it, "release/docs/", libName));
        return list;
    }

    private static List<String> getFinalJarsPaths(Iterator<URL> it, String pathPrefix, String libName) {
        ArrayList<String> archives = new ArrayList<String>();
        while (it.hasNext()) {
            URL originalURL = it.next();
            String archive = JavaMELibsPreviewHelper.createFinalPath(originalURL, pathPrefix, libName);
            if (archive == null) continue;
            archives.add(archive);
        }
        return archives;
    }

    private static String createFinalPath(URL originalURL, String pathPrefix, String libName) {
        URL archivURL = FileUtil.getArchiveFile((URL)originalURL);
        if (archivURL != null && FileUtil.isArchiveFile((URL)archivURL)) {
            return JavaMELibsPreviewHelper.createFinalPath4Archive(archivURL, pathPrefix);
        }
        return JavaMELibsPreviewHelper.createFinalPath4Folder(originalURL, pathPrefix, libName);
    }

    private static String createFinalPath4Archive(URL archivURL, String pathPrefix) {
        FileObject archiv = URLMapper.findFileObject((URL)archivURL);
        if (archiv == null) {
            return null;
        }
        String name = archiv.getNameExt();
        StringBuffer sb = new StringBuffer();
        sb.append(pathPrefix).append(name);
        return sb.toString();
    }

    private static String createFinalPath4Folder(URL originalURL, String pathPrefix, String libName) {
        FileObject folderToZip;
        if ("file".equals(originalURL.getProtocol()) && (folderToZip = URLMapper.findFileObject((URL)originalURL)) != null) {
            String name = libName + ".zip";
            return pathPrefix + name;
        }
        return null;
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(JavaMELibsPreviewHelper.class, (String)key, (Object[])args);
    }
}

