/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.JsonUtils;
import org.codeviation.pojson.Parser;
import org.codeviation.pojson.Pojson;

class Handlers {
    Handlers() {
    }

    static class IgnoreInfo
    extends Info {
        public IgnoreInfo(int kind, String name) {
            super(kind, name, true);
        }

        @Override
        public Info createInfo(int kind, String name) {
            return new IgnoreInfo(kind, null);
        }

        @Override
        public void addValue(Object value, String name) {
        }

        @Override
        public Object getValue() {
            return null;
        }
    }

    static class PojoInfo
    extends Info {
        private Field field;
        private Class<?> clazz;
        private Object o;
        private List<Object> al;

        PojoInfo(Object object) {
            super(-1, null);
            this.o = object;
            this.clazz = this.o.getClass();
        }

        PojoInfo(int kind, String name) {
            super(kind, name);
        }

        @Override
        public Info createInfo(int kind, String name) {
            PojoInfo i = new PojoInfo(kind, name);
            switch (kind) {
                case 1: {
                    try {
                        if (this.kind == -1) {
                            i.o = this.o;
                            i.clazz = this.o.getClass();
                            break;
                        }
                        i.o = this.clazz.newInstance();
                        i.clazz = this.clazz;
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case 0: {
                    if (this.kind == -1) {
                        i.clazz = this.clazz.getComponentType();
                    }
                    i.al = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    try {
                        i.field = this.clazz.getField(name);
                        i.clazz = i.field.getType();
                    }
                    catch (NoSuchFieldException ex) {
                        if (this.clazz.isAnnotationPresent(Pojson.IgnoreNonExisting.class)) {
                            return new IgnoreInfo(2, name);
                        }
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SecurityException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.kind == 2) {
                Class<?> t = this.field.getType();
                i.clazz = t.isArray() ? this.field.getType().getComponentType() : this.field.getType();
            }
            return i;
        }

        @Override
        public void addValue(Object value, String name) {
            switch (this.kind) {
                case 1: {
                    try {
                        Field f = this.o.getClass().getField(name);
                        f.setAccessible(true);
                        f.set(this.o, JsonUtils.fromJSON(f.getType(), value));
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (NoSuchFieldException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SecurityException ex) {
                        Logger.getLogger(Handlers.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case 0: {
                    this.al.add(value);
                    break;
                }
                case -1: {
                    if (this.clazz.isArray()) {
                        this.o = JsonUtils.fromJSON(this.clazz, value);
                        break;
                    }
                    this.o = value;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public Object getValue() {
            switch (this.kind) {
                case 1: {
                    return this.o;
                }
                case 0: {
                    return this.al;
                }
                case -1: {
                    return this.o;
                }
            }
            throw new IllegalStateException();
        }
    }

    static class CollectionsInfo
    extends Info {
        private Object root;
        private Map<String, Object> om;
        private List<Object> al;

        CollectionsInfo(int kind, String name) {
            super(kind, name);
        }

        @Override
        public Info createInfo(int kind, String name) {
            CollectionsInfo i = new CollectionsInfo(kind, name);
            switch (kind) {
                case 1: {
                    i.om = new LinkedHashMap<String, Object>();
                    break;
                }
                case 0: {
                    i.al = new ArrayList<Object>();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return i;
        }

        @Override
        public void addValue(Object value, String name) {
            switch (this.kind) {
                case 1: {
                    this.om.put(name, value);
                    break;
                }
                case 0: {
                    this.al.add(value);
                    break;
                }
                case -1: {
                    this.root = value;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public Object getValue() {
            switch (this.kind) {
                case 1: {
                    return this.om;
                }
                case 0: {
                    return this.al;
                }
                case -1: {
                    return this.root;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class Info {
        public static final int ROOT = -1;
        public static final int ARRAY = 0;
        public static final int OBJECT = 1;
        public static final int FIELD = 2;
        protected int kind;
        private String name;
        private boolean ignore;

        public Info(int kind, String name) {
            this(kind, name, false);
        }

        public Info(int kind, String name, boolean ignore) {
            this.kind = kind;
            this.name = name;
            this.ignore = ignore;
        }

        public String getName() {
            return this.name;
        }

        public abstract Info createInfo(int var1, String var2);

        public abstract void addValue(Object var1, String var2);

        public abstract Object getValue();

        public boolean isIgnore() {
            return this.ignore;
        }
    }

    public static class Generic
    implements Parser.Handler {
        private Stack<Info> s = new Stack();

        Generic(Info rootInfo) {
            this.s.push(rootInfo);
        }

        @Override
        public void objectStart() {
            this.s.push(this.s.peek().createInfo(1, null));
        }

        @Override
        public void arrayStart() {
            this.s.push(this.s.peek().createInfo(0, null));
        }

        @Override
        public void field(String name) {
            this.s.push(this.s.peek().createInfo(2, name));
        }

        @Override
        public void objectEnd() {
            Info i = this.s.pop();
            this.addValue(i.getValue());
        }

        @Override
        public void arrayEnd() {
            Info i = this.s.pop();
            this.addValue(i.getValue());
        }

        @Override
        public void bool(boolean value) {
            this.addValue(value ? Boolean.TRUE : Boolean.FALSE);
        }

        @Override
        public void string(String value) {
            this.addValue(value);
        }

        @Override
        public void nul() {
            this.addValue(null);
        }

        @Override
        public void number(long value) {
            this.addValue(value);
        }

        @Override
        public void number(double value) {
            this.addValue(value);
        }

        @Override
        public void comment(String comment) {
        }

        @Override
        public void lineComment(String comment) {
        }

        @Override
        public void error(Parser.Error error) {
            throw new IllegalArgumentException(error.toString());
        }

        private void addValue(Object value) {
            Info i = this.s.peek();
            if (i.kind == 2) {
                this.s.pop();
                if (!i.isIgnore()) {
                    this.s.peek().addValue(value, i.getName());
                }
            } else if (i.kind == 0 || i.kind == -1) {
                i.addValue(value, null);
            } else {
                throw new IllegalStateException("Should never happen");
            }
        }
    }
}

