/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Shingler<T extends Enum> {
    private int size;
    private BigInteger p;
    private BigInteger m;
    private BigInteger[] precomputed;

    public Shingler(Class<T> clazz, int size, int p, long m) {
        this.size = size;
        this.p = BigInteger.valueOf(p);
        this.m = BigInteger.valueOf(m);
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        this.precomputed = new BigInteger[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            BigInteger ev = BigInteger.valueOf(constants[i].ordinal() + 1);
            this.precomputed[i] = ev.multiply(this.p.pow(size - 1));
        }
    }

    public List<Long> compute(List<T> list) {
        long first = this.computeFirst(list);
        if (first == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        ArrayList<Long> r = new ArrayList<Long>(list.size() - this.size + 1);
        r.add(first);
        for (int i = 0; i < list.size() - this.size; ++i) {
            long next = this.computeNext(first, (Enum)list.get(i), (Enum)list.get(i + this.size));
            r.add(next);
            first = next;
        }
        return r;
    }

    long computeFirst(List<T> list) {
        if (list.size() < this.size) {
            return Long.MIN_VALUE;
        }
        BigInteger s = BigInteger.valueOf(((Enum)list.get(0)).ordinal() + 1);
        for (int i = 1; i < this.size; ++i) {
            s = s.multiply(this.p);
            s = s.add(BigInteger.valueOf(((Enum)list.get(i)).ordinal() + 1));
        }
        return s.mod(this.m).longValue();
    }

    long computeNext(long last, T toRemove, T toAdd) {
        BigInteger a = BigInteger.valueOf(((Enum)toAdd).ordinal() + 1);
        BigInteger r = BigInteger.valueOf(last);
        r = r.subtract(this.getPrecomputed(toRemove)).multiply(this.p).add(a);
        return r.mod(this.m).longValue();
    }

    private BigInteger getPrecomputed(T value) {
        return this.precomputed[((Enum)value).ordinal()];
    }
}

