/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.reflect.ClassUtils;

public class FieldUtils {
    private FieldUtils() {
    }

    public static Collection<Field> getDeclared(Class clazz, Filter<Field> filter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter must not be null!");
        }
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> result = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (filter != null && !filter.accept(field)) continue;
            result.add(field);
        }
        return result;
    }

    public static Map<String, Field> getAll(Class clazz, Class stopAt, Filter<Field> filter) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter must not be null!");
        }
        if (stopAt == null) {
            stopAt = Object.class;
        }
        if (stopAt.isInterface()) {
            throw new IllegalArgumentException("Stop at class " + stopAt.getName() + " must not be an interface");
        }
        if (!ClassUtils.isSuperclass(clazz, stopAt) && !clazz.equals(stopAt)) {
            throw new IllegalArgumentException("Stop At class class " + stopAt.getName() + " is not superclass of " + clazz.getName());
        }
        LinkedHashMap<String, Field> name2Field = new LinkedHashMap<String, Field>();
        boolean end = false;
        while (!end) {
            for (Field field : clazz.getDeclaredFields()) {
                if (((HashMap)name2Field).get(field.getName()) != null || filter != null && !filter.accept(field)) continue;
                name2Field.put(field.getName(), field);
            }
            if (clazz.equals(stopAt)) {
                end = true;
            }
            clazz = clazz.getSuperclass();
        }
        return name2Field;
    }

    public static Filter<Field> modifierFilterPositive(int ... modifier) {
        return new FieldModifierFilter(true, modifier);
    }

    public static Filter<Field> modifierFilterNegative(int ... modifier) {
        return new FieldModifierFilter(false, modifier);
    }

    private static class FieldModifierFilter
    implements Filter<Field> {
        private boolean isPositive;
        private int modifs;

        public FieldModifierFilter(boolean isPositive, int ... modifier) {
            this.isPositive = isPositive;
            for (int m : modifier) {
                this.modifs |= m;
            }
        }

        @Override
        public boolean accept(Field field) {
            return this.isPositive ? (field.getModifiers() & this.modifs) == this.modifs : (field.getModifiers() & this.modifs) == 0;
        }
    }
}

