/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.codeviation.commons.patterns.Filter;

public class Filters {
    private static Filter<?> ALLWAYS_TRUE = new LogicalFilter(4);
    private static Filter<?> ALLWAYS_FALSE = new LogicalFilter(5);

    private Filters() {
    }

    public static <T> Filter<T> And(Filter<T> ... filters) {
        if (filters.length < 2) {
            throw new IllegalArgumentException("At least two filters needed!");
        }
        return new LogicalFilter(0, filters);
    }

    public static <T> Filter<T> Or(Filter<T> ... filters) {
        if (filters.length < 2) {
            throw new IllegalArgumentException("At least two filters needed!");
        }
        return new LogicalFilter(1, filters);
    }

    public static <T> Filter<T> Not(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null!");
        }
        return new LogicalFilter(2, filter);
    }

    public static <T> Filter<T> True() {
        return ALLWAYS_TRUE;
    }

    public static <T> Filter<T> False() {
        return ALLWAYS_FALSE;
    }

    public static <T> Filter<T> NotNull() {
        return new NotNullFilter();
    }

    public static <T> Filter<T> IsIn(Collection<? extends T> container) {
        return new IsIn(container);
    }

    public static <T> Filter<T> IsIn(T ... container) {
        return new IsIn(Arrays.asList(container));
    }

    public static Filter<String> Regexp(String regexp) {
        return new Regexp(regexp);
    }

    public static Filter<Object> InstanceOf(Class clazz) {
        return new InstanceOf(clazz);
    }

    public static <T> Filter<T> IncludeExclude(Filter<T> include, Filter<T> exclude) {
        return new LogicalFilter(3, new Filter[]{include, exclude});
    }

    private static class InstanceOf
    implements Filter<Object> {
        private Class clazz;

        public InstanceOf(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean accept(Object object) {
            return this.clazz.isInstance(object);
        }
    }

    private static class Regexp
    implements Filter<String> {
        private Pattern pattern;

        public Regexp(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean accept(String text) {
            return this.pattern.matcher(text).matches();
        }
    }

    private static class IsIn<T>
    implements Filter<T> {
        private Collection container;

        public IsIn(Collection container) {
            this.container = container;
        }

        @Override
        public boolean accept(T object) {
            return this.container.contains(object);
        }
    }

    private static class NotNullFilter<T>
    implements Filter<T> {
        private NotNullFilter() {
        }

        @Override
        public boolean accept(T object) {
            return object != null;
        }
    }

    private static class LogicalFilter<T>
    implements Filter<T> {
        private static final int AND = 0;
        private static final int OR = 1;
        private static final int NOT = 2;
        private static final int INCLUDE_EXCLUDE = 3;
        private static final int TRUE = 4;
        private static final int FALSE = 5;
        private int op;
        private Filter<T>[] filters;
        private Filter<T> filter;

        private LogicalFilter(int op) {
            this.op = op;
        }

        private LogicalFilter(int op, Filter<T> filter) {
            this.op = op;
            this.filter = filter;
        }

        private LogicalFilter(int op, Filter<T>[] filters) {
            this.op = op;
            this.filters = filters;
        }

        @Override
        public boolean accept(T object) {
            switch (this.op) {
                case 0: {
                    for (Filter<T> f : this.filters) {
                        if (f == null || f.accept(object)) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    for (Filter<T> f : this.filters) {
                        if (f == null || !f.accept(object)) continue;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return !this.filter.accept(object);
                }
                case 3: {
                    return this.filters[0].accept(object) && !this.filters[1].accept(object);
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
            }
            throw new IllegalStateException("Unknown filter operation!");
        }
    }
}

