/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.settings.MakeSettings;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public abstract class MakeBaseAction
extends AbstractExecutorRunAction {
    @Override
    protected boolean accept(DataObject object) {
        return object != null && object.getCookie(MakeExecSupport.class) != null;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            this.performAction(activatedNodes[i], "");
        }
    }

    protected void performAction(Node node, String target) {
        this.performAction(node, target, null, null, MakeBaseAction.getProject(node), null, null);
    }

    protected Future<Integer> performAction(final Node node, final String target, final ExecutionListener listener, final Writer outputListener, final Project project, final List<String> additionalEnvironment, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private ExecutionService es;

                public void doWork() {
                    this.es = MakeBaseAction.this.prepare(node, target, listener, outputListener, project, additionalEnvironment, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = MakeBaseAction.getString("DLG_TITLE_Prepare", "make");
            String msg = MakeBaseAction.getString("MSG_TITLE_Prepare", "make");
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            ExecutionService es = this.prepare(node, target, listener, outputListener, project, additionalEnvironment, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private ExecutionService prepare(Node node, String target, ExecutionListener listener, Writer outputListener, Project project, List<String> additionalEnvironment, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        if (MakeSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File makefile = FileUtil.toFile((FileObject)fileObject);
        String buildDir = MakeBaseAction.getBuildDirectory(node, PredefinedToolKind.MakeTool);
        String executable = MakeBaseAction.getCommand(node, project, PredefinedToolKind.MakeTool, "make");
        String[] args = target.length() == 0 ? new String[]{"-f", makefile.getName()} : new String[]{"-f", makefile.getName(), target};
        ExecutionEnvironment execEnv = MakeBaseAction.getExecutionEnvironment(fileObject, project);
        buildDir = MakeBaseAction.convertToRemoteIfNeeded(execEnv, buildDir);
        if (buildDir == null) {
            return null;
        }
        Map<String, String> envMap = MakeBaseAction.getEnv(execEnv, node, additionalEnvironment);
        if (MakeBaseAction.isSunStudio(node, project)) {
            envMap.put("SPRO_EXPAND_ERRORS", "");
        }
        MakeBaseAction.traceExecutable(executable, buildDir, args, envMap);
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? MakeBaseAction.getString("MAKE_LABEL", node.getName(), target) : MakeBaseAction.getString("MAKE_REMOTE_LABEL", node.getName(), target, execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Project)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            return null;
        }
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, (LineConvertor)new CompilerLineConvertor(this.getCompilerSet(project), execEnv, fileObject.getParent()), inputOutput, "Make", syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setExecutable(executable).setWorkingDirectory(buildDir).setArguments(args).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(envMap);
        npb.redirectError();
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true).inputOutput(inputOutput).outLineBased(true).postExecution((Runnable)processChangeListener).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        return ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descr, (String)"make");
    }

    private CompilerSet getCompilerSet(Project project) {
        ToolchainProject toolchain;
        CompilerSet set = null;
        if (project != null && (toolchain = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            set = toolchain.getCompilerSet();
        }
        if (set == null) {
            set = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getDefaultCompilerSet();
        }
        return set;
    }
}

