/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.openide.util.Utilities;

public abstract class PhpProgram {
    private static final ExecutionDescriptor DEFAULT_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true);
    public static final ExecutionDescriptor.InputProcessorFactory ANSI_STRIPPING_FACTORY = new ExecutionDescriptor.InputProcessorFactory(){

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PhpProgram.class.getName());
    private static final String[] NO_PARAMETERS = new String[0];
    private final String program;
    private final String[] parameters;
    private final String fullCommand;

    public PhpProgram(String command) {
        if (command == null) {
            command = "";
        }
        String[] tokens = command.split(" * (?=\\-|/)", 2);
        switch (tokens.length) {
            case 1: {
                LOGGER.fine("Only program given (no parameters)");
                this.program = tokens[0].trim();
                this.parameters = NO_PARAMETERS;
                this.fullCommand = this.program;
                break;
            }
            default: {
                assert (tokens.length > 1);
                this.program = tokens[0].trim();
                this.parameters = Utilities.parseParameters((String)tokens[1].trim());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Parameters parsed: %s => %s", tokens[1].trim(), Arrays.asList(this.parameters)));
                }
                this.fullCommand = command.trim();
            }
        }
    }

    public final String getProgram() {
        return this.program;
    }

    public final String[] getParameters() {
        return (String[])this.parameters.clone();
    }

    public final String getFullCommand() {
        return this.fullCommand;
    }

    public final boolean isValid() {
        return this.validate() == null;
    }

    public abstract String validate();

    public ExternalProcessBuilder getProcessBuilder() {
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder(this.program);
        for (String param : this.parameters) {
            processBuilder = processBuilder.addArgument(param);
        }
        return processBuilder;
    }

    public static ExecutionDescriptor getExecutionDescriptor() {
        return DEFAULT_DESCRIPTOR;
    }

    public static Future<Integer> executeLater(ExternalProcessBuilder processBuilder, ExecutionDescriptor executionDescriptor, String title) {
        return ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)title).run();
    }

    public static int executeAndWait(ExternalProcessBuilder processBuilder, ExecutionDescriptor executionDescriptor, String title) throws ExecutionException, InterruptedException {
        return (Integer)ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)title).run().get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [program: ");
        sb.append(this.program);
        sb.append(", parameters: ");
        sb.append(Arrays.asList(this.parameters));
        sb.append("]");
        return sb.toString();
    }

    public static final class InvalidPhpProgramException
    extends Exception {
        private static final long serialVersionUID = -831989756418354L;

        public InvalidPhpProgramException(String message) {
            super(message);
        }
    }
}

