/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class FindComponentModules {
    private static final RequestProcessor RP = new RequestProcessor("Find Modules");
    private final Collection<String> codeNames;
    private final FeatureInfo[] infos;
    public final String DO_CHECK = "do-check";
    private final String ENABLE_LATER = "enable-later";
    private RequestProcessor.Task findingTask;
    private Collection<UpdateElement> forInstall = null;
    private Collection<UpdateElement> forEnable = null;
    private Runnable doFind = new Runnable(){

        @Override
        public void run() {
            FindComponentModules.this.findComponentModules();
        }
    };

    public FindComponentModules(FeatureInfo info, FeatureInfo ... additional) {
        ArrayList<FeatureInfo> l = new ArrayList<FeatureInfo>();
        l.add(info);
        l.addAll(Arrays.asList(additional));
        this.infos = l.toArray(new FeatureInfo[0]);
        if (this.infos.length == 1) {
            this.codeNames = info.getCodeNames();
        } else {
            this.codeNames = new HashSet<String>(info.getCodeNames());
            for (FeatureInfo fi : additional) {
                this.codeNames.addAll(fi.getCodeNames());
            }
        }
        this.findingTask = RP.post(this.doFind);
    }

    public Collection<UpdateElement> getModulesForInstall() {
        this.findingTask.waitFinished();
        return this.forInstall;
    }

    public Collection<UpdateElement> getModulesForEnable() {
        this.findingTask.waitFinished();
        return this.forEnable;
    }

    public void writeEnableLater(Collection<UpdateElement> modules) {
        Preferences pref = FindComponentModules.getPreferences();
        if (modules == null) {
            pref.remove("enable-later");
            return;
        }
        String value = "";
        for (UpdateElement m : modules) {
            value = value + (value.length() == 0 ? m.getCodeName() : ", " + m.getCodeName());
        }
        if (value.trim().length() == 0) {
            pref.remove("enable-later");
        } else {
            pref.put("enable-later", value);
        }
    }

    private Set<String> clusterClosure(Collection<UpdateElement> all) {
        HashSet<String> closure = new HashSet<String>();
        for (UpdateElement ue : all) {
            for (FeatureInfo featureInfo : FeatureManager.features()) {
                if (!featureInfo.getCodeNames().contains(ue.getCodeName())) continue;
                closure.addAll(featureInfo.getCodeNames());
            }
        }
        return closure;
    }

    private Collection<UpdateElement> readEnableLater() {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        Preferences pref = FindComponentModules.getPreferences();
        String value = pref.get("enable-later", null);
        if (value != null && value.trim().length() > 0) {
            StringTokenizer en = new StringTokenizer(value, ",");
            while (en.hasMoreElements()) {
                String codeName = ((String)en.nextElement()).trim();
                UpdateElement el = FindComponentModules.findUpdateElement(codeName, true);
                if (el == null) continue;
                res.add(el);
            }
        }
        return res;
    }

    public Collection<UpdateElement> getVisibleUpdateElements(Collection<UpdateElement> elems) {
        String prefCNB = this.infos[0].getPreferredCodeNameBase();
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateElement el : new LinkedList<UpdateElement>(elems)) {
            if (UpdateManager.TYPE.KIT_MODULE.equals((Object)el.getUpdateUnit().getType())) {
                res.add(el);
            }
            if (!el.getUpdateUnit().getCodeName().equals(prefCNB)) continue;
            return Collections.singleton(el);
        }
        if (res.size() > 1) {
            FoDFileSystem.LOG.warning("No prefCNB found " + prefCNB + " using multiple " + res);
        }
        return res;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(FindComponentModules.class);
    }

    private void findComponentModules() {
        long start = System.currentTimeMillis();
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<UpdateElement> elementsForInstall = this.getMissingModules(units);
        this.forInstall = this.getAllForInstall(elementsForInstall);
        Collection<UpdateElement> elementsForEnable = this.getDisabledModules(units);
        this.forEnable = this.getAllForEnable(elementsForEnable, units);
    }

    private Collection<UpdateElement> getMissingModules(Collection<UpdateUnit> allUnits) {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateUnit unit : allUnits) {
            if (unit.getInstalled() != null || !this.codeNames.contains(unit.getCodeName())) continue;
            res.add((UpdateElement)unit.getAvailableUpdates().get(0));
        }
        return res;
    }

    private Collection<UpdateElement> getAllForInstall(Collection<UpdateElement> elements) {
        HashSet<UpdateElement> all = new HashSet<UpdateElement>();
        for (UpdateElement el : elements) {
            OperationContainer.OperationInfo info;
            OperationContainer ocForInstall = OperationContainer.createForInstall();
            if (!ocForInstall.canBeAdded(el.getUpdateUnit(), el) || (info = ocForInstall.add(el)) == null) continue;
            Set reqs = info.getRequiredElements();
            ocForInstall.add((Collection)reqs);
            Set breaks = info.getBrokenDependencies();
            if (!breaks.isEmpty()) continue;
            all.add(el);
            all.addAll(reqs);
        }
        return all;
    }

    private Collection<UpdateElement> getDisabledModules(Collection<UpdateUnit> allUnits) {
        HashSet<UpdateElement> res = new HashSet<UpdateElement>();
        for (UpdateUnit unit : allUnits) {
            if (unit.getInstalled() == null || !this.codeNames.contains(unit.getCodeName()) || unit.getInstalled().isEnabled()) continue;
            res.add(unit.getInstalled());
        }
        return res;
    }

    private Collection<UpdateElement> getAllForEnable(Collection<UpdateElement> elements, Collection<UpdateUnit> units) {
        Collection<UpdateElement> toAdd = elements;
        HashSet<UpdateElement> all = new HashSet<UpdateElement>();
        HashSet<String> ignore = new HashSet<String>();
        OperationContainer ocForEnable = OperationContainer.createForEnable();
        while (!toAdd.isEmpty()) {
            for (UpdateElement el : toAdd) {
                if (el == null) continue;
                if (ocForEnable.canBeAdded(el.getUpdateUnit(), el)) {
                    OperationContainer.OperationInfo inf = ocForEnable.add(el);
                    if (inf == null) continue;
                    Set reqs = inf.getRequiredElements();
                    ocForEnable.add((Collection)reqs);
                    all.add(el);
                    all.addAll(reqs);
                    continue;
                }
                ignore.add(el.getCodeName());
            }
            Set<String> clusterClosure = this.clusterClosure(all);
            for (UpdateElement el : all) {
                clusterClosure.remove(el.getCodeName());
            }
            clusterClosure.removeAll(ignore);
            if (clusterClosure.isEmpty()) break;
            toAdd = new HashSet<UpdateElement>();
            for (UpdateUnit uu : units) {
                if (!clusterClosure.contains(uu.getCodeName())) continue;
                toAdd.add(uu.getInstalled());
            }
        }
        return all;
    }

    private static UpdateElement findUpdateElement(String codeName, boolean isInstalled) {
        UpdateElement res = null;
        for (UpdateUnit u : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!codeName.equals(u.getCodeName())) continue;
            if (isInstalled && u.getInstalled() != null) {
                res = u.getInstalled();
                break;
            }
            if (isInstalled || u.getAvailableUpdates().isEmpty()) break;
            res = (UpdateElement)u.getAvailableUpdates().get(0);
            break;
        }
        return res;
    }
}

