/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DerbyPropertiesPanel
extends JPanel {
    private DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private DocumentListener docListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            DerbyPropertiesPanel.this.validatePanel();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DerbyPropertiesPanel.this.validatePanel();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DerbyPropertiesPanel.this.validatePanel();
        }
    };
    public JButton browseButton;
    public JTextField derbyInstall;
    public JTextPane derbyInstallInfo;
    public JLabel derbySystemHomeLabel;
    public JTextField derbySystemHomeTextField;
    public JLabel installLabel;
    public JButton jButton1;

    public static boolean showDerbyProperties() {
        assert (SwingUtilities.isEventDispatchThread());
        DerbyPropertiesPanel panel = new DerbyPropertiesPanel();
        String title = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_SetDerbySystemHome");
        DialogDescriptor desc = new DialogDescriptor((Object)panel, title);
        desc.createNotificationLineSupport();
        panel.setDialogDescriptor(desc);
        while (true) {
            boolean success;
            Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
            if (panel.getInstallLocation().length() == 0) {
                panel.setIntroduction();
            }
            String acsd = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel");
            dialog.getAccessibleContext().setAccessibleDescription(acsd);
            dialog.setVisible(true);
            dialog.dispose();
            if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                return false;
            }
            File derbySystemHome = new File(panel.getDerbySystemHome());
            if (derbySystemHome.exists() || (success = derbySystemHome.mkdirs())) break;
            String message = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ERR_DerbySystemHomeCantCreate");
            NotifyDescriptor.Message ndesc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
        }
        new RegisterSampleDatabase();
        if (!panel.getDerbySystemHome().equals(DerbyOptions.getDefault().getSystemHome())) {
            DerbyOptions.getDefault().setSystemHome(panel.getDerbySystemHome());
        }
        if (!panel.getInstallLocation().equals(DerbyOptions.getDefault().getLocation())) {
            DerbyOptions.getDefault().setLocation(panel.getInstallLocation());
        }
        return true;
    }

    private DerbyPropertiesPanel() {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.derbyInstallInfo.setBackground(this.getBackground());
        this.derbySystemHomeTextField.getDocument().addDocumentListener(this.docListener);
        this.derbySystemHomeTextField.setText(DerbyOptions.getDefault().getSystemHome());
        this.derbyInstall.getDocument().addDocumentListener(this.docListener);
        this.derbyInstall.setText(DerbyOptions.getDefault().getLocation());
    }

    private void setDialogDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private String getDerbySystemHome() {
        return this.derbySystemHomeTextField.getText().trim();
    }

    private String getInstallLocation() {
        return this.derbyInstall.getText().trim();
    }

    private void setInstallLocation(String location) {
        this.derbyInstall.setText(location);
    }

    private void setDerbySystemHome(String derbySystemHome) {
        this.derbySystemHomeTextField.setText(derbySystemHome);
    }

    public void setIntroduction() {
        String info = NbBundle.getMessage(CreateDatabasePanel.class, (String)"INFO_EnterDerbyLocation");
        this.descriptor.getNotificationLineSupport().setInformationMessage(info);
        this.descriptor.setValid(false);
    }

    private void validatePanel() {
        if (this.descriptor == null) {
            return;
        }
        String error = null;
        String warning = null;
        String info = null;
        String location = this.getInstallLocation();
        if (location != null && location.length() > 0) {
            File locationFile = new File(location).getAbsoluteFile();
            if (!locationFile.exists()) {
                error = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)locationFile);
            }
            if (!Util.isDerbyInstallLocation(locationFile)) {
                error = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_InvalidDerbyLocation", (Object)locationFile);
            }
        } else if (location.length() == 0) {
            info = NbBundle.getMessage(CreateDatabasePanel.class, (String)"INFO_EnterDerbyLocation");
        }
        if (error == null) {
            File derbySystemHome = new File(this.getDerbySystemHome());
            if (derbySystemHome.getPath().length() <= 0) {
                info = NbBundle.getMessage(CreateDatabasePanel.class, (String)"INFO_DerbySystemHomeNotEntered");
            }
            if (derbySystemHome.exists() && !derbySystemHome.isDirectory()) {
                error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotDirectory");
            } else if (derbySystemHome.getPath().length() > 0 && !derbySystemHome.isAbsolute()) {
                error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotAbsolute");
            }
        }
        if (error != null) {
            this.descriptor.setValid(false);
            this.descriptor.getNotificationLineSupport().setErrorMessage(error);
        } else if (warning != null) {
            this.descriptor.setValid(false);
            this.descriptor.getNotificationLineSupport().setWarningMessage(warning);
        } else if (info != null) {
            this.descriptor.setValid(false);
            this.descriptor.getNotificationLineSupport().setInformationMessage(info);
        } else {
            this.descriptor.setValid(true);
            this.descriptor.getNotificationLineSupport().clearMessages();
        }
    }

    private void initComponents() {
        this.derbySystemHomeLabel = new JLabel();
        this.derbySystemHomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.installLabel = new JLabel();
        this.derbyInstall = new JTextField();
        this.jButton1 = new JButton();
        this.derbyInstallInfo = new JTextPane();
        this.derbySystemHomeLabel.setLabelFor(this.derbySystemHomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.derbySystemHomeLabel, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_DerbySystemHome"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DerbyPropertiesPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.installLabel.setLabelFor(this.derbyInstall);
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Install"));
        this.derbyInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DerbyPropertiesPanel.this.derbyInstallActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Browse2"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DerbyPropertiesPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.derbyInstallInfo.setEditable(false);
        this.derbyInstallInfo.setText(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_InstallationInfo"));
        this.derbyInstallInfo.setAutoscrolls(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.derbyInstallInfo, -1, 498, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.derbySystemHomeLabel).addPreferredGap(1).add((Component)this.derbySystemHomeTextField, -1, 267, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.installLabel).addPreferredGap(0).add((Component)this.derbyInstall, -1, 265, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.derbyInstallInfo, -2, 57, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.installLabel).add((Component)this.derbyInstall, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.derbySystemHomeLabel).add((Component)this.derbySystemHomeTextField, -2, -1, -2).add((Component)this.browseButton)).addContainerGap(79, Short.MAX_VALUE)));
        this.derbySystemHomeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSN_CreateDatabasePanel_databaseLocationTextField"));
        this.derbySystemHomeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_derbySystemHomeTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_browseButton"));
        this.derbyInstall.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_derbySystemHomeTextField"));
        this.derbyInstallInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSN_DerbySystemHomePanel_derbyInstallInfoTextField"));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(1);
        String location = this.getInstallLocation();
        if (location.length() > 0) {
            chooser.setSelectedFile(new File(location));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setInstallLocation(chooser.getSelectedFile().getAbsolutePath());
    }

    private void derbyInstallActionPerformed(ActionEvent evt) {
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(1);
        String derbySystemHome = this.getDerbySystemHome();
        if (derbySystemHome.length() > 0) {
            chooser.setSelectedFile(new File(derbySystemHome));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setDerbySystemHome(chooser.getSelectedFile().getAbsolutePath());
    }

    private static class RegisterSampleDatabase {
        private static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
        private static final String CONN_NAME = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/sample [app on APP]";
        private boolean registered;
        private final JDBCDriverListener jdbcDriverListener = new JDBCDriverListener(){

            public void driversChanged() {
                RegisterSampleDatabase.this.registerDatabase();
            }
        };

        RegisterSampleDatabase() {
            if (JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET).length == 0) {
                JDBCDriverManager.getDefault().addDriverListener(this.jdbcDriverListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerDatabase() {
            RegisterSampleDatabase registerSampleDatabase = this;
            synchronized (registerSampleDatabase) {
                if (this.registered) {
                    return;
                }
                this.registered = true;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        JDBCDriver[] drvsArray = JDBCDriverManager.getDefault().getDrivers(RegisterSampleDatabase.DRIVER_CLASS_NET);
                        if (drvsArray.length > 0 && ConnectionManager.getDefault().getConnection(CONN_NAME) == null) {
                            DerbyDatabases.createSampleDatabase();
                        }
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (DatabaseException de) {
                        Exceptions.printStackTrace((Throwable)de);
                    }
                    finally {
                        JDBCDriverManager.getDefault().removeDriverListener(RegisterSampleDatabase.this.jdbcDriverListener);
                    }
                }
            });
        }
    }
}

