/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.settings;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.filesystems.FileObject;

public final class TransformHistory
implements Serializable {
    private static final long serialVersionUID = -6268945703343989727L;
    private ListMap xmlOutputMap = null;
    private ListMap xslOutputMap = null;
    private boolean overwriteOutput = false;
    private int processOutput = 2;
    public static final int DO_NOTHING = 0;
    public static final int APPLY_DEFAULT_ACTION = 1;
    public static final int OPEN_IN_BROWSER = 2;
    public static final String TRANSFORM_HISTORY_ATTRIBUTE = "org.netbeans.modules.xsl.settings.TransformHistory";

    public String[] getXMLs() {
        return this.getXMLOutputMap().getInputs();
    }

    public String getLastXML() {
        return this.getXMLOutputMap().getLastInput();
    }

    public String[] getXSLs() {
        return this.getXSLOutputMap().getInputs();
    }

    public String getLastXSL() {
        return this.getXSLOutputMap().getLastInput();
    }

    public String getXMLOutput(String xml) {
        return this.getXMLOutputMap().getOutput(xml);
    }

    public String getLastXMLOutput() {
        return this.getXMLOutput(this.getLastXML());
    }

    public String getXSLOutput(String xsl) {
        return this.getXSLOutputMap().getOutput(xsl);
    }

    public String getLastXSLOutput() {
        return this.getXSLOutput(this.getLastXSL());
    }

    public void addXML(String xml, String output) {
        this.getXMLOutputMap().put(xml, output);
    }

    public void addXSL(String xsl, String output) {
        this.getXSLOutputMap().put(xsl, output);
    }

    public boolean isOverwriteOutput() {
        return this.overwriteOutput;
    }

    public void setOverwriteOutput(boolean overwrite) {
        this.overwriteOutput = overwrite;
    }

    public int getProcessOutput() {
        return this.processOutput;
    }

    public void setProcessOutput(int process) {
        this.processOutput = process;
    }

    private ListMap getXMLOutputMap() {
        if (this.xmlOutputMap == null) {
            this.xmlOutputMap = new ListMap();
        }
        return this.xmlOutputMap;
    }

    private ListMap getXSLOutputMap() {
        if (this.xslOutputMap == null) {
            this.xslOutputMap = new ListMap();
        }
        return this.xslOutputMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" [ xmlOutputMap= ").append(this.xmlOutputMap);
        sb.append(", xslOutputMap= ").append(this.xslOutputMap);
        sb.append(", overwriteOutput= ").append(this.overwriteOutput);
        sb.append(", processOutput= ").append(this.processOutput).append(" ]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransformHistory)) {
            return false;
        }
        TransformHistory peer = (TransformHistory)obj;
        if (!TransformHistory.equals(this.xmlOutputMap, peer.xmlOutputMap)) {
            return false;
        }
        if (!TransformHistory.equals(this.xslOutputMap, peer.xslOutputMap)) {
            return false;
        }
        if (this.overwriteOutput != peer.overwriteOutput) {
            return false;
        }
        return this.processOutput == peer.processOutput;
    }

    static boolean equals(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj1 == obj2;
    }

    private static class ListMap
    implements Serializable {
        private static final long serialVersionUID = 6341102578706167575L;
        public static final int MAX = 5;
        private transient List inputList;
        private transient Map inputOutputMap;
        private Object[] inputOutputArray;

        public ListMap() {
            this.init();
        }

        private void init() {
            this.inputList = new LinkedList();
            this.inputOutputMap = new HashMap();
            if (this.inputOutputArray == null) {
                return;
            }
            for (int i = 0; i < this.inputOutputArray.length; i += 2) {
                Object input = this.inputOutputArray[i];
                Object output = this.inputOutputArray[i + 1];
                try {
                    if (input instanceof FileObject) {
                        input = TransformUtil.getURLName((FileObject)input);
                    } else if (input != null && !(input instanceof String)) {
                        input = input.toString();
                    }
                    if (output instanceof FileObject) {
                        output = TransformUtil.getURLName((FileObject)output);
                    } else if (output != null && !(output instanceof String)) {
                        output = output.toString();
                    }
                    this.inputList.add(input);
                    this.inputOutputMap.put(input, output);
                    continue;
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
        }

        public void put(String input, String output) {
            Object old = this.inputOutputMap.remove(input);
            this.inputList.remove(input);
            this.inputOutputMap.put(input, output);
            this.inputList.add(0, input);
            if (this.inputList.size() > 5) {
                Object over = this.inputList.remove(this.inputList.size() - 1);
                this.inputOutputMap.remove(over);
            }
        }

        public String[] getInputs() {
            return this.inputList.toArray(new String[0]);
        }

        public String getLastInput() {
            if (this.inputList.isEmpty()) {
                return null;
            }
            return (String)this.inputList.get(0);
        }

        public String getOutput(String input) {
            return (String)this.inputOutputMap.get(input);
        }

        public String[] getArray() {
            if (this.inputList.size() == 0) {
                return null;
            }
            String[] array = new String[2 * this.inputList.size()];
            for (int i = 0; i < this.inputList.size(); ++i) {
                String input;
                array[2 * i] = input = (String)this.inputList.get(i);
                array[2 * i + 1] = (String)this.inputOutputMap.get(input);
            }
            return array;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(" [ inputList= ").append(this.inputList);
            sb.append(", inputOutputMap.keySet= ").append(this.inputOutputMap.keySet());
            sb.append(", inputOutputMap.values= ").append(this.inputOutputMap.values());
            sb.append(", xmlOutputArray= ").append(this.inputOutputArray == null ? "null" : Arrays.asList(this.inputOutputArray).toString());
            sb.append(" ]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListMap)) {
                return false;
            }
            ListMap peer = (ListMap)obj;
            if (!TransformHistory.equals(this.inputList, peer.inputList)) {
                return false;
            }
            return TransformHistory.equals(this.inputOutputMap, peer.inputOutputMap);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.init();
            this.inputOutputArray = null;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            this.inputOutputArray = this.getArray();
            oos.defaultWriteObject();
            this.inputOutputArray = null;
        }
    }
}

