/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.SchemaElementUtil;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DBSchemaManager {
    public static final String DBSCHEMA_EXT = "dbschema";
    private DatabaseConnection oldDBConn;
    private boolean oldDBConnWasConnected;
    private Connection conn;
    private SchemaElement schemaElement;
    private SQLException exception;
    private FileObject schemaFileObject;
    private SchemaElement fileSchemaElement;

    public SchemaElement getSchemaElement(final DatabaseConnection databaseConnection) throws SQLException {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.oldDBConn == databaseConnection && this.schemaElement != null) {
            return this.schemaElement;
        }
        this.schemaElement = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.oldDBConn != null && this.oldDBConn != databaseConnection && !this.oldDBConnWasConnected) {
            arrayList.add(new ProgressSupport.BackgroundAction(){

                public void run(ProgressSupport.Context context) {
                    context.progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_ClosingPreviousConnection"));
                    ConnectionManager.getDefault().disconnect(DBSchemaManager.this.oldDBConn);
                    DBSchemaManager.this.oldDBConn = null;
                    DBSchemaManager.this.conn = null;
                }
            });
        } else {
            this.oldDBConn = null;
            this.conn = null;
        }
        arrayList.add(new ProgressSupport.EventThreadAction(){

            public void run(ProgressSupport.Context context) {
                ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                DBSchemaManager.this.conn = databaseConnection.getJDBCConnection();
            }

            public boolean isEnabled() {
                DBSchemaManager.this.conn = databaseConnection.getJDBCConnection();
                DBSchemaManager.this.oldDBConnWasConnected = DBSchemaManager.this.conn != null;
                return !DBSchemaManager.this.oldDBConnWasConnected;
            }
        });
        arrayList.add(new ProgressSupport.Action(){
            private SchemaElementImpl schemaElementImpl;
            private boolean cancelled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final ProgressSupport.Context context) {
                context.progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingSchema"));
                DBSchemaManager.this.oldDBConn = databaseConnection;
                ConnectionProvider connectionProvider = null;
                try {
                    connectionProvider = new ConnectionProvider(DBSchemaManager.this.conn, databaseConnection.getDriverClass());
                    connectionProvider.setSchema(databaseConnection.getSchema());
                }
                catch (SQLException sQLException) {
                    DBSchemaManager.this.exception = sQLException;
                    return;
                }
                3 var3_4 = this;
                synchronized (var3_4) {
                    if (this.cancelled) {
                        return;
                    }
                    this.schemaElementImpl = new SchemaElementImpl(connectionProvider);
                }
                try {
                    this.schemaElementImpl.setName(DBIdentifier.create((String)DBSchemaManager.DBSCHEMA_EXT));
                }
                catch (DBException dBException) {
                    Logger.getLogger("global").log(Level.INFO, null, dBException);
                    return;
                }
                DBSchemaManager.this.schemaElement = new SchemaElement((SchemaElement.Impl)this.schemaElementImpl);
                this.schemaElementImpl.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = propertyChangeEvent.getPropertyName();
                        String string2 = null;
                        if ("totalCount".equals(string)) {
                            int n = (Integer)propertyChangeEvent.getNewValue();
                            context.switchToDeterminate(n);
                        } else if ("progress".equals(string)) {
                            int n = (Integer)propertyChangeEvent.getNewValue();
                            context.progress(n);
                        } else if ("tableName".equals(string)) {
                            string2 = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingTable", (Object)propertyChangeEvent.getNewValue());
                        } else if ("viewName".equals(string)) {
                            string2 = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingView", (Object)propertyChangeEvent.getNewValue());
                        } else if ("FKt".equals(string)) {
                            string2 = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingTableKeys", (Object)propertyChangeEvent.getNewValue());
                        } else if ("FKv".equals(string)) {
                            string2 = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingViewKeys", (Object)propertyChangeEvent.getNewValue());
                        }
                        if (string2 != null) {
                            context.progress(string2);
                        }
                    }
                });
                this.schemaElementImpl.initTables(connectionProvider);
            }

            public boolean isEnabled() {
                return DBSchemaManager.this.conn != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    this.cancelled = true;
                    if (this.schemaElementImpl != null) {
                        this.schemaElementImpl.setStop(true);
                    }
                }
                return true;
            }

            protected boolean isBackground() {
                return true;
            }
        });
        this.exception = null;
        boolean bl = ProgressSupport.invoke(arrayList, (boolean)true);
        if (this.exception != null) {
            throw this.exception;
        }
        if (!bl) {
            this.schemaElement = null;
        }
        return this.schemaElement;
    }

    public SchemaElement getSchemaElement(final FileObject fileObject) {
        assert (SwingUtilities.isEventDispatchThread());
        if (fileObject == this.schemaFileObject) {
            return this.fileSchemaElement;
        }
        this.schemaFileObject = null;
        this.fileSchemaElement = null;
        ArrayList<4> arrayList = new ArrayList<4>();
        arrayList.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                context.progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_ReadingSchemaFile"));
                DBSchemaManager.this.schemaFileObject = fileObject;
                DBSchemaManager.this.fileSchemaElement = SchemaElementUtil.forName((FileObject)fileObject);
            }
        });
        ProgressSupport.invoke(arrayList);
        return this.fileSchemaElement;
    }

    public static FileObject updateDBSchemas(SchemaElement schemaElement, DBSchemaFileList dBSchemaFileList, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = DBSchemaManager.updateDBSchemas(schemaElement, dBSchemaFileList);
        if (fileObject2 == null) {
            fileObject2 = DBSchemaManager.writeDBSchema(schemaElement, fileObject, string);
        }
        return fileObject2;
    }

    private static FileObject updateDBSchemas(SchemaElement schemaElement, DBSchemaFileList dBSchemaFileList) throws IOException {
        FileObject fileObject = null;
        DBIdentifier dBIdentifier = schemaElement.getSchema();
        String string = dBIdentifier != null ? dBIdentifier.getName() : null;
        for (FileObject fileObject2 : dBSchemaFileList.getFileList()) {
            String string2;
            SchemaElement schemaElement2 = SchemaElementUtil.forName((FileObject)fileObject2);
            DBIdentifier dBIdentifier2 = schemaElement2.getSchema();
            String string3 = string2 = dBIdentifier2 != null ? dBIdentifier2.getName() : null;
            if (!Utilities.compareObjects((Object)schemaElement2.getUrl(), (Object)schemaElement.getUrl()) || !Utilities.compareObjects((Object)string2, (Object)string)) continue;
            DBIdentifier dBIdentifier3 = schemaElement2.getName();
            DBSchemaManager.overwriteDBSchema(schemaElement, fileObject2, dBIdentifier3);
            fileObject = fileObject2;
        }
        return fileObject;
    }

    private static FileObject writeDBSchema(SchemaElement schemaElement, FileObject fileObject, String string) throws IOException {
        String string2 = schemaElement.getSchema().getName();
        String string3 = (string2 != null && string2 != "" ? string2 + "_" : "") + string;
        string3 = string3.replace('.', '_');
        String string4 = FileUtil.findFreeFileName((FileObject)fileObject, (String)string3, (String)DBSCHEMA_EXT);
        DBIdentifier dBIdentifier = DBIdentifier.create((String)string4);
        try {
            schemaElement.setName(dBIdentifier);
        }
        catch (DBException dBException) {
            IOException iOException = new IOException(dBException.getMessage());
            iOException.initCause(dBException);
            throw iOException;
        }
        FileObject fileObject2 = fileObject.createData(string4, DBSCHEMA_EXT);
        DBSchemaManager.writeSchemaElement(schemaElement, fileObject2);
        return fileObject2;
    }

    private static void overwriteDBSchema(SchemaElement schemaElement, FileObject fileObject, DBIdentifier dBIdentifier) throws IOException {
        try {
            schemaElement.setName(dBIdentifier);
        }
        catch (DBException dBException) {
            IOException iOException = new IOException(dBException.getMessage());
            iOException.initCause(dBException);
            throw iOException;
        }
        FileObject fileObject2 = fileObject.getParent();
        String string = fileObject.getName();
        String string2 = fileObject.getExt();
        fileObject.delete();
        FileObject fileObject3 = fileObject2.createData(string, string2);
        DBSchemaManager.writeSchemaElement(schemaElement, fileObject3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSchemaElement(SchemaElement schemaElement, FileObject fileObject) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock));
            try {
                schemaElement.save((OutputStream)bufferedOutputStream);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

