/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.j2ee.persistence.dd.common.JPAParseUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;

public final class PersistenceMetadata {
    private static final PersistenceMetadata DEFAULT = new PersistenceMetadata();
    private Map ddMap = new WeakHashMap(5);

    private PersistenceMetadata() {
    }

    public static PersistenceMetadata getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistence getRoot(FileObject fileObject) throws IOException {
        if (fileObject == null) {
            return null;
        }
        Persistence persistence = null;
        Map map = this.ddMap;
        synchronized (map) {
            persistence = (Persistence)this.ddMap.get(fileObject);
            if (persistence == null) {
                InputStream inputStream = fileObject.getInputStream();
                String string = "1.0";
                try {
                    string = JPAParseUtils.getVersion(inputStream);
                }
                catch (SAXException sAXException) {
                    Exceptions.printStackTrace((Throwable)sAXException);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                inputStream = fileObject.getInputStream();
                persistence = "2.0".equals(string) ? org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence.createGraph(inputStream) : org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence.createGraph(inputStream);
                inputStream.close();
                this.ddMap.put(fileObject, persistence);
            }
        }
        return persistence;
    }

    public void refresh(FileObject fileObject) {
        if (fileObject != null) {
            this.ddMap.remove(fileObject);
        }
    }
}

