/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.groups.Group;
import org.openide.NotificationLineSupport;
import org.openide.util.NbBundle;

public abstract class GroupEditPanel
extends JPanel {
    private NotificationLineSupport supp;

    public abstract void applyChanges();

    void setNotificationLineSupport(NotificationLineSupport s) {
        this.supp = s;
    }

    NotificationLineSupport getNotificationLineSupport() {
        return this.supp;
    }

    void startPerformingNameChecks(final JTextField field, final String initial) {
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doCheck();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doCheck();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doCheck();
            }

            private void doCheck() {
                GroupEditPanel.this.getNotificationLineSupport().clearMessages();
                String newText = field.getText();
                if (!newText.equals(initial)) {
                    for (Group g : Group.allGroups()) {
                        if (!newText.equals(g.getNameOrNull())) continue;
                        GroupEditPanel.this.getNotificationLineSupport().setWarningMessage(NbBundle.getBundle(GroupEditPanel.class).getString("WARN_GroupExists"));
                    }
                }
            }
        });
    }
}

