/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Hacks {
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    static final RequestProcessor RP = new RequestProcessor("Project UI");

    private Hacks() {
    }

    static void keepCurrentProjectNameUpdated() {
        final TopComponent.Registry r = TopComponent.getRegistry();
        final AtomicReference<2> displayNameListener = new AtomicReference<2>();
        final RequestProcessor.Task task = RP.create(new Runnable(){
            String lastKnownTitle;

            @Override
            public void run() {
                String pname;
                Object[] sel = r.getActivatedNodes();
                HashSet<Project> projects = new HashSet<Project>();
                boolean noProjectsOpen = OpenProjectList.getDefault().getOpenProjects().length == 0;
                for (int i = 0; i < sel.length; ++i) {
                    FileObject f;
                    Lookup l = sel[i].getLookup();
                    Project p = (Project)l.lookup(Project.class);
                    if (p != null) {
                        projects.add(p);
                        if (!noProjectsOpen) continue;
                        Logger.getLogger(Hacks.class.getName()).fine("Activated node selection " + Arrays.toString(sel) + " contains nonopen project " + p + " though none are open; leak? activated TC: " + r.getActivated() + " current nodes: " + Arrays.toString(r.getCurrentNodes()) + " (report in issue #102805)");
                        continue;
                    }
                    DataObject d = (DataObject)l.lookup(DataObject.class);
                    if (d == null || (p = FileOwnerQuery.getOwner((FileObject)(f = d.getPrimaryFile()))) == null) continue;
                    projects.add(p);
                }
                if (projects.size() == 1) {
                    Project p = (Project)projects.iterator().next();
                    ProjectInformation info = ProjectUtils.getInformation((Project)p);
                    info.removePropertyChangeListener((PropertyChangeListener)displayNameListener.get());
                    info.addPropertyChangeListener((PropertyChangeListener)displayNameListener.get());
                    pname = info.getDisplayName();
                    assert (pname != null) : p;
                } else {
                    pname = projects.isEmpty() ? null : NbBundle.getMessage(Hacks.class, (String)"LBL_MultipleProjects");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String format = NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString(pname != null ? "CTL_MainWindow_Title" : "CTL_MainWindow_Title_No_Project");
                        String title = pname != null ? MessageFormat.format(format, BUILD_NUMBER, pname) : MessageFormat.format(format, BUILD_NUMBER);
                        Frame mainWindow = WindowManager.getDefault().getMainWindow();
                        if (lastKnownTitle == null || lastKnownTitle.equals(mainWindow.getTitle())) {
                            lastKnownTitle = title;
                            mainWindow.setTitle(title);
                        }
                    }
                });
            }
        });
        displayNameListener.set(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String prop = ev.getPropertyName();
                if (prop == null || prop.equals("displayName")) {
                    task.schedule(0);
                }
            }
        });
        r.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("activatedNodes".equals(ev.getPropertyName())) {
                    task.schedule(200);
                }
            }
        });
    }

    static void reloadPanelsInWizard(TemplateWizard tw, DataObject dobj) {
        try {
            Class<?> twClazz = Class.forName("org.openide.loaders.TemplateWizard", true, Thread.currentThread().getContextClassLoader());
            if (twClazz != null) {
                Method reloadPanels = twClazz.getDeclaredMethod("reload", DataObject.class);
                reloadPanels.setAccessible(true);
                reloadPanels.invoke((Object)tw, dobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

