/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.editor;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.identity.profile.ui.MessagePanel;
import org.netbeans.modules.identity.profile.ui.SecurityView;
import org.netbeans.modules.identity.profile.ui.WSCSecurityView;
import org.netbeans.modules.identity.profile.ui.WSPSecurityView;
import org.netbeans.modules.identity.profile.ui.support.J2eeProjectHelper;
import org.netbeans.modules.identity.profile.ui.support.WsdlData;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SecurityWSEditor
implements WSEditor {
    private J2eeProjectHelper helper;
    private JPanel iPanel;
    private JaxWsModel jaxWsModel;

    public SecurityWSEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public JComponent createWSEditorComponent(Node node) {
        this.helper = J2eeProjectHelper.newInstance(node, this.jaxWsModel);
        if (!this.helper.isAppServerSun()) {
            this.iPanel = new MessagePanel(NbBundle.getMessage(SecurityWSEditor.class, (String)"LBL_AppSrvNotSun"));
            return this.iPanel;
        }
        if (this.helper.isSecurable()) {
            this.helper.refreshBuildScript();
            List<WsdlData> list = this.helper.getWsdlData();
            if (!this.helper.isServer() && list != null) {
                for (WsdlData wsdlData : list) {
                    if (wsdlData != null && wsdlData.isValid()) continue;
                    this.iPanel = new MessagePanel(NbBundle.getMessage(SecurityWSEditor.class, (String)"LBL_CannotParseWSDL"));
                    return this.iPanel;
                }
            }
            if (this.iPanel == null) {
                this.iPanel = this.setUpSecurityPanel();
            }
        } else {
            String string = null;
            string = this.helper.noServiceRefExists() ? NbBundle.getMessage(SecurityWSEditor.class, (String)"LBL_NoServiceRefs") : NbBundle.getMessage(SecurityWSEditor.class, (String)"LBL_UnsupportedProject");
            this.iPanel = new MessagePanel(string);
        }
        return this.iPanel;
    }

    public String getTitle() {
        return NbBundle.getMessage(SecurityWSEditor.class, (String)"LBL_WSSecurityProviderTitle");
    }

    public void save(Node node) {
        if (this.iPanel instanceof SecurityView) {
            ((SecurityView)((Object)this.iPanel)).save();
        }
    }

    public void cancel(Node node) {
        if (this.iPanel instanceof SecurityView) {
            ((SecurityView)((Object)this.iPanel)).cancel();
        }
    }

    private JPanel setUpSecurityPanel() {
        if (this.helper.isServer()) {
            return new WSPSecurityView(this.helper);
        }
        return new WSCSecurityView(this.helper);
    }

    public String getDescription() {
        return NbBundle.getMessage(SecurityWSEditor.class, (String)"AM_SECURITY_DESC");
    }
}

